/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.bcpg;

import edu.illinois.ncsa.bouncycastle.bcpg.BCPGInputStream;
import edu.illinois.ncsa.bouncycastle.bcpg.BCPGKey;
import edu.illinois.ncsa.bouncycastle.bcpg.BCPGObject;
import edu.illinois.ncsa.bouncycastle.bcpg.BCPGOutputStream;
import edu.illinois.ncsa.bouncycastle.bcpg.MPInteger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class RSASecretBCPGKey
extends BCPGObject
implements BCPGKey {
    MPInteger d;
    MPInteger p;
    MPInteger q;
    MPInteger u;
    BigInteger expP;
    BigInteger expQ;
    BigInteger crt;

    public RSASecretBCPGKey(BCPGInputStream bCPGInputStream) throws IOException {
        this.d = new MPInteger(bCPGInputStream);
        this.p = new MPInteger(bCPGInputStream);
        this.q = new MPInteger(bCPGInputStream);
        this.u = new MPInteger(bCPGInputStream);
        this.expP = this.d.getValue().remainder(this.p.getValue().subtract(BigInteger.valueOf(1L)));
        this.expQ = this.d.getValue().remainder(this.q.getValue().subtract(BigInteger.valueOf(1L)));
        this.crt = this.q.getValue().modInverse(this.p.getValue());
    }

    public RSASecretBCPGKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        int n = bigInteger2.compareTo(bigInteger3);
        if (n >= 0) {
            if (n == 0) {
                throw new IllegalArgumentException("p and q cannot be equal");
            }
            BigInteger bigInteger4 = bigInteger2;
            bigInteger2 = bigInteger3;
            bigInteger3 = bigInteger4;
        }
        this.d = new MPInteger(bigInteger);
        this.p = new MPInteger(bigInteger2);
        this.q = new MPInteger(bigInteger3);
        this.u = new MPInteger(bigInteger2.modInverse(bigInteger3));
        this.expP = bigInteger.remainder(bigInteger2.subtract(BigInteger.valueOf(1L)));
        this.expQ = bigInteger.remainder(bigInteger3.subtract(BigInteger.valueOf(1L)));
        this.crt = bigInteger3.modInverse(bigInteger2);
    }

    public BigInteger getModulus() {
        return this.p.getValue().multiply(this.q.getValue());
    }

    public BigInteger getPrivateExponent() {
        return this.d.getValue();
    }

    public BigInteger getPrimeP() {
        return this.p.getValue();
    }

    public BigInteger getPrimeQ() {
        return this.q.getValue();
    }

    public BigInteger getPrimeExponentP() {
        return this.expP;
    }

    public BigInteger getPrimeExponentQ() {
        return this.expQ;
    }

    public BigInteger getCrtCoefficient() {
        return this.crt;
    }

    public String getFormat() {
        return "PGP";
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(byteArrayOutputStream);
            bCPGOutputStream.writeObject(this);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writeObject(this.d);
        bCPGOutputStream.writeObject(this.p);
        bCPGOutputStream.writeObject(this.q);
        bCPGOutputStream.writeObject(this.u);
    }
}

