/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.generators;

import edu.illinois.ncsa.bouncycastle.crypto.AsymmetricCipherKeyPair;
import edu.illinois.ncsa.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import edu.illinois.ncsa.bouncycastle.crypto.KeyGenerationParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.ECDomainParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.ECKeyGenerationParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.ECPrivateKeyParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.ECPublicKeyParameters;
import edu.illinois.ncsa.bouncycastle.math.ec.ECConstants;
import edu.illinois.ncsa.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        ECKeyGenerationParameters eCKeyGenerationParameters = (ECKeyGenerationParameters)keyGenerationParameters;
        this.random = eCKeyGenerationParameters.getRandom();
        this.params = eCKeyGenerationParameters.getDomainParameters();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n = bigInteger2.bitLength();
        while ((bigInteger = new BigInteger(n, this.random)).equals(ZERO) || bigInteger.compareTo(bigInteger2) >= 0) {
        }
        ECPoint eCPoint = this.params.getG().multiply(bigInteger);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(eCPoint, this.params), new ECPrivateKeyParameters(bigInteger, this.params));
    }
}

