/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.test;

import edu.illinois.ncsa.bouncycastle.crypto.BlockCipher;
import edu.illinois.ncsa.bouncycastle.crypto.BufferedBlockCipher;
import edu.illinois.ncsa.bouncycastle.crypto.CipherParameters;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;

public class BlockCipherMonteCarloTest
extends SimpleTest {
    int id;
    int iterations;
    BlockCipher engine;
    CipherParameters param;
    byte[] input;
    byte[] output;

    public BlockCipherMonteCarloTest(int n, int n2, BlockCipher blockCipher, CipherParameters cipherParameters, String string, String string2) {
        this.id = n;
        this.iterations = n2;
        this.engine = blockCipher;
        this.param = cipherParameters;
        this.input = Hex.decode(string);
        this.output = Hex.decode(string2);
    }

    public String getName() {
        return this.engine.getAlgorithmName() + " Monte Carlo Test " + this.id;
    }

    public void performTest() throws Exception {
        int n;
        int n2;
        BufferedBlockCipher bufferedBlockCipher = new BufferedBlockCipher(this.engine);
        bufferedBlockCipher.init(true, this.param);
        byte[] byArray = new byte[this.input.length];
        System.arraycopy(this.input, 0, byArray, 0, byArray.length);
        for (n2 = 0; n2 != this.iterations; ++n2) {
            n = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray, 0);
            bufferedBlockCipher.doFinal(byArray, n);
        }
        if (!this.areEqual(byArray, this.output)) {
            this.fail("failed - expected " + new String(Hex.encode(this.output)) + " got " + new String(Hex.encode(byArray)));
        }
        bufferedBlockCipher.init(false, this.param);
        for (n2 = 0; n2 != this.iterations; ++n2) {
            n = bufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray, 0);
            bufferedBlockCipher.doFinal(byArray, n);
        }
        if (!this.areEqual(this.input, byArray)) {
            this.fail("failed reversal");
        }
    }
}

