/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.test;

import edu.illinois.ncsa.bouncycastle.crypto.AsymmetricCipherKeyPair;
import edu.illinois.ncsa.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import edu.illinois.ncsa.bouncycastle.crypto.digests.SHA1Digest;
import edu.illinois.ncsa.bouncycastle.crypto.engines.IESEngine;
import edu.illinois.ncsa.bouncycastle.crypto.engines.TwofishEngine;
import edu.illinois.ncsa.bouncycastle.crypto.generators.ECKeyPairGenerator;
import edu.illinois.ncsa.bouncycastle.crypto.generators.KDF2BytesGenerator;
import edu.illinois.ncsa.bouncycastle.crypto.macs.HMac;
import edu.illinois.ncsa.bouncycastle.crypto.modes.CBCBlockCipher;
import edu.illinois.ncsa.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import edu.illinois.ncsa.bouncycastle.crypto.params.ECDomainParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.ECKeyGenerationParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.ECPrivateKeyParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.ECPublicKeyParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.IESParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.IESWithCipherParameters;
import edu.illinois.ncsa.bouncycastle.math.ec.ECCurve;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECIESTest
extends SimpleTest {
    ECIESTest() {
    }

    public String getName() {
        return "ECIES";
    }

    private void staticTest() throws Exception {
        byte[] byArray;
        ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("6277101735386680763835789423207666416083908700390324961279"), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16));
        ECDomainParameters eCDomainParameters = new ECDomainParameters(fp, fp.decodePoint(Hex.decode("03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012")), new BigInteger("6277101735386680763835789423176059013767194773182842284081"));
        ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(new BigInteger("651056770906015076056810763456358567190100156695615665659"), eCDomainParameters);
        ECPublicKeyParameters eCPublicKeyParameters = new ECPublicKeyParameters(fp.decodePoint(Hex.decode("0262b12d60690cdcf330babab6e69763b471f994dd702d16a5")), eCDomainParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = new AsymmetricCipherKeyPair(eCPublicKeyParameters, eCPrivateKeyParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = new AsymmetricCipherKeyPair(eCPublicKeyParameters, eCPrivateKeyParameters);
        IESEngine iESEngine = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()));
        IESEngine iESEngine2 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()));
        byte[] byArray2 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] byArray3 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        IESParameters iESParameters = new IESParameters(byArray2, byArray3, 64);
        iESEngine.init(true, asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPublic(), iESParameters);
        iESEngine2.init(false, asymmetricCipherKeyPair2.getPrivate(), asymmetricCipherKeyPair.getPublic(), iESParameters);
        byte[] byArray4 = Hex.decode("1234567890abcdef");
        byte[] byArray5 = iESEngine.processBlock(byArray4, 0, byArray4.length);
        if (!this.areEqual(byArray5, Hex.decode("2442ae1fbf90dd9c06b0dcc3b27e69bd11c9aee4ad4cfc9e50eceb44"))) {
            this.fail("stream cipher test failed on enc");
        }
        if (!this.areEqual(byArray = iESEngine2.processBlock(byArray5, 0, byArray5.length), byArray4)) {
            this.fail("stream cipher test failed");
        }
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        PaddedBufferedBlockCipher paddedBufferedBlockCipher2 = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        iESEngine = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), paddedBufferedBlockCipher);
        iESEngine2 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), paddedBufferedBlockCipher2);
        byArray2 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byArray3 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        iESParameters = new IESWithCipherParameters(byArray2, byArray3, 64, 128);
        iESEngine.init(true, asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPublic(), iESParameters);
        iESEngine2.init(false, asymmetricCipherKeyPair2.getPrivate(), asymmetricCipherKeyPair.getPublic(), iESParameters);
        byArray4 = Hex.decode("1234567890abcdef");
        byArray5 = iESEngine.processBlock(byArray4, 0, byArray4.length);
        if (!this.areEqual(byArray5, Hex.decode("2ea288651e21576215f2424bbb3f68816e282e3931b44bd1c429ebdb5f1b290cf1b13309"))) {
            this.fail("twofish cipher test failed on enc");
        }
        if (!this.areEqual(byArray = iESEngine2.processBlock(byArray5, 0, byArray5.length), byArray4)) {
            this.fail("twofish cipher test failed");
        }
    }

    private void doTest(AsymmetricCipherKeyPair asymmetricCipherKeyPair, AsymmetricCipherKeyPair asymmetricCipherKeyPair2) throws Exception {
        IESEngine iESEngine = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()));
        IESEngine iESEngine2 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()));
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] byArray2 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        IESParameters iESParameters = new IESParameters(byArray, byArray2, 64);
        iESEngine.init(true, asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPublic(), iESParameters);
        iESEngine2.init(false, asymmetricCipherKeyPair2.getPrivate(), asymmetricCipherKeyPair.getPublic(), iESParameters);
        byte[] byArray3 = Hex.decode("1234567890abcdef");
        byte[] byArray4 = iESEngine.processBlock(byArray3, 0, byArray3.length);
        byte[] byArray5 = iESEngine2.processBlock(byArray4, 0, byArray4.length);
        if (!this.areEqual(byArray5, byArray3)) {
            this.fail("stream cipher test failed");
        }
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        PaddedBufferedBlockCipher paddedBufferedBlockCipher2 = new PaddedBufferedBlockCipher(new CBCBlockCipher(new TwofishEngine()));
        iESEngine = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), paddedBufferedBlockCipher);
        iESEngine2 = new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), paddedBufferedBlockCipher2);
        byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byArray2 = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        iESParameters = new IESWithCipherParameters(byArray, byArray2, 64, 128);
        iESEngine.init(true, asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPublic(), iESParameters);
        iESEngine2.init(false, asymmetricCipherKeyPair2.getPrivate(), asymmetricCipherKeyPair.getPublic(), iESParameters);
        byArray3 = Hex.decode("1234567890abcdef");
        byArray4 = iESEngine.processBlock(byArray3, 0, byArray3.length);
        byArray5 = iESEngine2.processBlock(byArray4, 0, byArray4.length);
        if (!this.areEqual(byArray5, byArray3)) {
            this.fail("twofish cipher test failed");
        }
    }

    public void performTest() throws Exception {
        this.staticTest();
        ECCurve.Fp fp = new ECCurve.Fp(new BigInteger("6277101735386680763835789423207666416083908700390324961279"), new BigInteger("fffffffffffffffffffffffffffffffefffffffffffffffc", 16), new BigInteger("64210519e59c80e70fa7e9ab72243049feb8deecc146b9b1", 16));
        ECDomainParameters eCDomainParameters = new ECDomainParameters(fp, fp.decodePoint(Hex.decode("03188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012")), new BigInteger("6277101735386680763835789423176059013767194773182842284081"));
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCDomainParameters, new SecureRandom());
        eCKeyPairGenerator.init(eCKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = eCKeyPairGenerator.generateKeyPair();
        this.doTest(asymmetricCipherKeyPair, asymmetricCipherKeyPair2);
    }

    public static void main(String[] stringArray) {
        ECIESTest.runTest(new ECIESTest());
    }
}

