/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.test;

import edu.illinois.ncsa.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import edu.illinois.ncsa.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import edu.illinois.ncsa.bouncycastle.crypto.modes.gcm.Tables1kGCMExponentiator;
import edu.illinois.ncsa.bouncycastle.crypto.modes.gcm.Tables64kGCMMultiplier;
import edu.illinois.ncsa.bouncycastle.crypto.util.Pack;
import edu.illinois.ncsa.bouncycastle.util.Arrays;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import junit.framework.TestCase;

public class GCMReorderTest
extends TestCase {
    private static final byte[] H;
    private static final SecureRandom random;
    private static final GCMMultiplier mul;
    private static final GCMExponentiator exp;
    private static final byte[] EMPTY;

    public void testCombine() throws Exception {
        for (int i = 0; i < 10; ++i) {
            byte[] byArray = this.randomBytes(1000);
            byte[] byArray2 = this.randomBytes(1000);
            byte[] byArray3 = this.GHASH(byArray, EMPTY);
            byte[] byArray4 = this.GHASH(EMPTY, byArray2);
            byte[] byArray5 = this.GHASH(byArray, byArray2);
            byte[] byArray6 = this.combine_GHASH(byArray3, (long)byArray.length * 8L, byArray4, (long)byArray2.length * 8L);
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(byArray5, byArray6));
        }
    }

    public void testConcatAuth() throws Exception {
        for (int i = 0; i < 10; ++i) {
            byte[] byArray = this.randomBlocks(100);
            byte[] byArray2 = this.randomBytes(1000);
            byte[] byArray3 = this.concatArrays(byArray, byArray2);
            byte[] byArray4 = this.GHASH(byArray, EMPTY);
            byte[] byArray5 = this.GHASH(byArray2, EMPTY);
            byte[] byArray6 = this.GHASH(byArray3, EMPTY);
            byte[] byArray7 = this.concatAuth_GHASH(byArray4, (long)byArray.length * 8L, byArray5, (long)byArray2.length * 8L);
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(byArray6, byArray7));
        }
    }

    public void testConcatCrypt() throws Exception {
        for (int i = 0; i < 10; ++i) {
            byte[] byArray = this.randomBlocks(100);
            byte[] byArray2 = this.randomBytes(1000);
            byte[] byArray3 = this.concatArrays(byArray, byArray2);
            byte[] byArray4 = this.GHASH(EMPTY, byArray);
            byte[] byArray5 = this.GHASH(EMPTY, byArray2);
            byte[] byArray6 = this.GHASH(EMPTY, byArray3);
            byte[] byArray7 = this.concatCrypt_GHASH(byArray4, (long)byArray.length * 8L, byArray5, (long)byArray2.length * 8L);
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(byArray6, byArray7));
        }
    }

    public void testExp() {
        int n;
        Object[] objectArray = new byte[16];
        objectArray[0] = -128;
        Object object = new byte[16];
        for (n = 0; n != 100; ++n) {
            exp.exponentiateX(n, (byte[])object);
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(objectArray, object));
            mul.multiplyH((byte[])objectArray);
        }
        objectArray = new long[]{10L, 1L, 8L, 17L, 24L, 13L, 2L, 13L, 2L, 3L};
        object = new byte[][]{Hex.decode("9185848a877bd87ba071e281f476e8e7"), Hex.decode("697ce3052137d80745d524474fb6b290"), Hex.decode("2696fc47198bb23b11296e4f88720a17"), Hex.decode("01f2f0ead011a4ae0cf3572f1b76dd8e"), Hex.decode("a53060694a044e4b7fa1e661c5a7bb6b"), Hex.decode("39c0392e8b6b0e04a7565c85394c2c4c"), Hex.decode("519c362d502e07f2d8b7597a359a5214"), Hex.decode("5a527a393675705e19b2117f67695af4"), Hex.decode("27fc0901d1d332a53ba4d4386c2109d2"), Hex.decode("93ca9b57174aabedf8220e83366d7df6")};
        for (n = 0; n != 10; ++n) {
            byte by = objectArray[n];
            byte[] byArray = Arrays.clone((byte[])object[n]);
            byte[] byArray2 = Arrays.clone(byArray);
            int n2 = 0;
            while ((long)n2 < by) {
                mul.multiplyH(byArray2);
                ++n2;
            }
            byte[] byArray3 = new byte[16];
            exp.exponentiateX(by, byArray3);
            byte[] byArray4 = GCMReorderTest.multiply(byArray, byArray3);
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(byArray2, byArray4));
        }
    }

    public void testMultiply() {
        byte[] byArray = Arrays.clone(H);
        mul.multiplyH(byArray);
        GCMReorderTest.assertTrue((boolean)Arrays.areEqual(byArray, GCMReorderTest.multiply(H, H)));
        for (int i = 0; i < 10; ++i) {
            byte[] byArray2 = new byte[16];
            random.nextBytes(byArray2);
            byte[] byArray3 = new byte[16];
            random.nextBytes(byArray3);
            byArray = Arrays.clone(byArray2);
            mul.multiplyH(byArray);
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(byArray, GCMReorderTest.multiply(byArray2, H)));
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(byArray, GCMReorderTest.multiply(H, byArray2)));
            byArray = Arrays.clone(byArray3);
            mul.multiplyH(byArray);
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(byArray, GCMReorderTest.multiply(byArray3, H)));
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(byArray, GCMReorderTest.multiply(H, byArray3)));
            GCMReorderTest.assertTrue((boolean)Arrays.areEqual(GCMReorderTest.multiply(byArray2, byArray3), GCMReorderTest.multiply(byArray3, byArray2)));
        }
    }

    private byte[] randomBlocks(int n) {
        byte[] byArray = new byte[16 * random.nextInt(n)];
        random.nextBytes(byArray);
        return byArray;
    }

    private byte[] randomBytes(int n) {
        byte[] byArray = new byte[random.nextInt(n)];
        random.nextBytes(byArray);
        return byArray;
    }

    private byte[] concatArrays(byte[] byArray, byte[] byArray2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write(byArray2);
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] combine_GHASH(byte[] byArray, long l, byte[] byArray2, long l2) {
        long l3 = l2 + 127L >>> 7;
        byte[] byArray3 = new byte[16];
        exp.exponentiateX(l3, byArray3);
        byte[] byArray4 = GCMReorderTest.lengthBlock(l, 0L);
        mul.multiplyH(byArray4);
        byte[] byArray5 = Arrays.clone(byArray);
        GCMReorderTest.xor(byArray5, byArray4);
        byArray5 = GCMReorderTest.multiply(byArray5, byArray3);
        GCMReorderTest.xor(byArray5, byArray4);
        GCMReorderTest.xor(byArray5, byArray2);
        return byArray5;
    }

    private byte[] concatAuth_GHASH(byte[] byArray, long l, byte[] byArray2, long l2) {
        long l3 = l2 + 127L >>> 7;
        byte[] byArray3 = GCMReorderTest.lengthBlock(l, 0L);
        mul.multiplyH(byArray3);
        byte[] byArray4 = GCMReorderTest.lengthBlock(l2 ^ l + l2, 0L);
        mul.multiplyH(byArray4);
        byte[] byArray5 = new byte[16];
        exp.exponentiateX(l3, byArray5);
        byte[] byArray6 = Arrays.clone(byArray);
        GCMReorderTest.xor(byArray6, byArray3);
        byArray6 = GCMReorderTest.multiply(byArray6, byArray5);
        GCMReorderTest.xor(byArray6, byArray4);
        GCMReorderTest.xor(byArray6, byArray2);
        return byArray6;
    }

    private byte[] concatCrypt_GHASH(byte[] byArray, long l, byte[] byArray2, long l2) {
        long l3 = l2 + 127L >>> 7;
        byte[] byArray3 = GCMReorderTest.lengthBlock(0L, l);
        mul.multiplyH(byArray3);
        byte[] byArray4 = GCMReorderTest.lengthBlock(0L, l2 ^ l + l2);
        mul.multiplyH(byArray4);
        byte[] byArray5 = new byte[16];
        exp.exponentiateX(l3, byArray5);
        byte[] byArray6 = Arrays.clone(byArray);
        GCMReorderTest.xor(byArray6, byArray3);
        byArray6 = GCMReorderTest.multiply(byArray6, byArray5);
        GCMReorderTest.xor(byArray6, byArray4);
        GCMReorderTest.xor(byArray6, byArray2);
        return byArray6;
    }

    private byte[] GHASH(byte[] byArray, byte[] byArray2) {
        int n;
        byte[] byArray3;
        int n2;
        byte[] byArray4 = new byte[16];
        for (n2 = 0; n2 < byArray.length; n2 += 16) {
            byArray3 = new byte[16];
            n = Math.min(byArray.length - n2, 16);
            System.arraycopy(byArray, n2, byArray3, 0, n);
            GCMReorderTest.xor(byArray4, byArray3);
            mul.multiplyH(byArray4);
        }
        for (n2 = 0; n2 < byArray2.length; n2 += 16) {
            byArray3 = new byte[16];
            n = Math.min(byArray2.length - n2, 16);
            System.arraycopy(byArray2, n2, byArray3, 0, n);
            GCMReorderTest.xor(byArray4, byArray3);
            mul.multiplyH(byArray4);
        }
        GCMReorderTest.xor(byArray4, GCMReorderTest.lengthBlock((long)byArray.length * 8L, (long)byArray2.length * 8L));
        mul.multiplyH(byArray4);
        return byArray4;
    }

    private static byte[] lengthBlock(long l, long l2) {
        byte[] byArray = new byte[16];
        GCMReorderTest.packLength(l, byArray, 0);
        GCMReorderTest.packLength(l2, byArray, 8);
        return byArray;
    }

    private static void xor(byte[] byArray, byte[] byArray2) {
        for (int i = 15; i >= 0; --i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] ^ byArray2[i]);
        }
    }

    private static void packLength(long l, byte[] byArray, int n) {
        Pack.intToBigEndian((int)(l >>> 32), byArray, n);
        Pack.intToBigEndian((int)l, byArray, n + 4);
    }

    private static byte[] multiply(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = Arrays.clone(byArray2);
        for (int i = 0; i < 16; ++i) {
            byte by = byArray[i];
            for (int j = 7; j >= 0; --j) {
                if ((by & 1 << j) != 0) {
                    GCMReorderTest.xor(byArray3, byArray4);
                }
                boolean bl = (byArray4[15] & 1) != 0;
                GCMReorderTest.shiftRight(byArray4);
                if (!bl) continue;
                byArray4[0] = (byte)(byArray4[0] ^ 0xFFFFFFE1);
            }
        }
        return byArray3;
    }

    private static void shiftRight(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (true) {
            int n3 = byArray[n] & 0xFF;
            byArray[n] = (byte)(n3 >>> 1 | n2);
            if (++n == 16) break;
            n2 = (n3 & 1) << 7;
        }
    }

    static {
        random = new SecureRandom();
        mul = new Tables64kGCMMultiplier();
        exp = new Tables1kGCMExponentiator();
        EMPTY = new byte[0];
        H = new byte[16];
        random.nextBytes(H);
        mul.init(Arrays.clone(H));
        exp.init(Arrays.clone(H));
    }
}

