/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.test;

import edu.illinois.ncsa.bouncycastle.crypto.InvalidCipherTextException;
import edu.illinois.ncsa.bouncycastle.crypto.engines.AESFastEngine;
import edu.illinois.ncsa.bouncycastle.crypto.modes.GCMBlockCipher;
import edu.illinois.ncsa.bouncycastle.crypto.modes.gcm.BasicGCMMultiplier;
import edu.illinois.ncsa.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import edu.illinois.ncsa.bouncycastle.crypto.modes.gcm.Tables64kGCMMultiplier;
import edu.illinois.ncsa.bouncycastle.crypto.modes.gcm.Tables8kGCMMultiplier;
import edu.illinois.ncsa.bouncycastle.crypto.params.AEADParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.KeyParameter;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.security.SecureRandom;

public class GCMTest
extends SimpleTest {
    private static final String[][] TEST_VECTORS = new String[][]{{"Test Case 1", "00000000000000000000000000000000", "", "", "000000000000000000000000", "", "58e2fccefa7e3061367f1d57a4e7455a"}, {"Test Case 2", "00000000000000000000000000000000", "00000000000000000000000000000000", "", "000000000000000000000000", "0388dace60b6a392f328c2b971b2fe78", "ab6e47d42cec13bdf53a67b21257bddf"}, {"Test Case 3", "feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b391aafd255", "", "cafebabefacedbaddecaf888", "42831ec2217774244b7221b784d0d49ce3aa212f2c02a4e035c17e2329aca12e21d514b25466931c7d8f6a5aac84aa051ba30b396a0aac973d58e091473f5985", "4d5c2af327cd64a62cf35abd2ba6fab4"}, {"Test Case 4", "feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "cafebabefacedbaddecaf888", "42831ec2217774244b7221b784d0d49ce3aa212f2c02a4e035c17e2329aca12e21d514b25466931c7d8f6a5aac84aa051ba30b396a0aac973d58e091", "5bc94fbc3221a5db94fae95ae7121a47"}, {"Test Case 5", "feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "cafebabefacedbad", "61353b4c2806934a777ff51fa22a4755699b2a714fcdc6f83766e5f97b6c742373806900e49f24b22b097544d4896b424989b5e1ebac0f07c23f4598", "3612d2e79e3b0785561be14aaca2fccb"}, {"Test Case 6", "feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "9313225df88406e555909c5aff5269aa6a7a9538534f7da1e4c303d2a318a728c3c0c95156809539fcf0e2429a6b525416aedbf5a0de6a57a637b39b", "8ce24998625615b603a033aca13fb894be9112a5c3a211a8ba262a3cca7e2ca701e4a9a4fba43c90ccdcb281d48c7c6fd62875d2aca417034c34aee5", "619cc5aefffe0bfa462af43c1699d050"}, {"Test Case 7", "000000000000000000000000000000000000000000000000", "", "", "000000000000000000000000", "", "cd33b28ac773f74ba00ed1f312572435"}, {"Test Case 8", "000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "", "000000000000000000000000", "98e7247c07f0fe411c267e4384b0f600", "2ff58d80033927ab8ef4d4587514f0fb"}, {"Test Case 9", "feffe9928665731c6d6a8f9467308308feffe9928665731c", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b391aafd255", "", "cafebabefacedbaddecaf888", "3980ca0b3c00e841eb06fac4872a2757859e1ceaa6efd984628593b40ca1e19c7d773d00c144c525ac619d18c84a3f4718e2448b2fe324d9ccda2710acade256", "9924a7c8587336bfb118024db8674a14"}, {"Test Case 10", "feffe9928665731c6d6a8f9467308308feffe9928665731c", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "cafebabefacedbaddecaf888", "3980ca0b3c00e841eb06fac4872a2757859e1ceaa6efd984628593b40ca1e19c7d773d00c144c525ac619d18c84a3f4718e2448b2fe324d9ccda2710", "2519498e80f1478f37ba55bd6d27618c"}, {"Test Case 11", "feffe9928665731c6d6a8f9467308308feffe9928665731c", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "cafebabefacedbad", "0f10f599ae14a154ed24b36e25324db8c566632ef2bbb34f8347280fc4507057fddc29df9a471f75c66541d4d4dad1c9e93a19a58e8b473fa0f062f7", "65dcc57fcf623a24094fcca40d3533f8"}, {"Test Case 12", "feffe9928665731c6d6a8f9467308308feffe9928665731c", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "9313225df88406e555909c5aff5269aa6a7a9538534f7da1e4c303d2a318a728c3c0c95156809539fcf0e2429a6b525416aedbf5a0de6a57a637b39b", "d27e88681ce3243c4830165a8fdcf9ff1de9a1d8e6b447ef6ef7b79828666e4581e79012af34ddd9e2f037589b292db3e67c036745fa22e7e9b7373b", "dcf566ff291c25bbb8568fc3d376a6d9"}, {"Test Case 13", "0000000000000000000000000000000000000000000000000000000000000000", "", "", "000000000000000000000000", "", "530f8afbc74536b9a963b4f1c4cb738b"}, {"Test Case 14", "0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000", "", "000000000000000000000000", "cea7403d4d606b6e074ec5d3baf39d18", "d0d1c8a799996bf0265b98b5d48ab919"}, {"Test Case 15", "feffe9928665731c6d6a8f9467308308feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b391aafd255", "", "cafebabefacedbaddecaf888", "522dc1f099567d07f47f37a32a84427d643a8cdcbfe5c0c97598a2bd2555d1aa8cb08e48590dbb3da7b08b1056828838c5f61e6393ba7a0abcc9f662898015ad", "b094dac5d93471bdec1a502270e3cc6c"}, {"Test Case 16", "feffe9928665731c6d6a8f9467308308feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "cafebabefacedbaddecaf888", "522dc1f099567d07f47f37a32a84427d643a8cdcbfe5c0c97598a2bd2555d1aa8cb08e48590dbb3da7b08b1056828838c5f61e6393ba7a0abcc9f662", "76fc6ece0f4e1768cddf8853bb2d551b"}, {"Test Case 17", "feffe9928665731c6d6a8f9467308308feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "cafebabefacedbad", "c3762df1ca787d32ae47c13bf19844cbaf1ae14d0b976afac52ff7d79bba9de0feb582d33934a4f0954cc2363bc73f7862ac430e64abe499f47c9b1f", "3a337dbf46a792c45e454913fe2ea8f2"}, {"Test Case 18", "feffe9928665731c6d6a8f9467308308feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "9313225df88406e555909c5aff5269aa6a7a9538534f7da1e4c303d2a318a728c3c0c95156809539fcf0e2429a6b525416aedbf5a0de6a57a637b39b", "5a8def2f0c9e53f1f75d7853659e2a20eeb2b22aafde6419a058ab4f6f746bf40fc0c3b780f244452da3ebf1c5d82cdea2418997200ef82e44ae7e3f", "a44a8266ee1c8eb0c8b5d4cf5ae9f19a"}};

    public String getName() {
        return "GCM";
    }

    public void performTest() throws Exception {
        for (int i = 0; i < TEST_VECTORS.length; ++i) {
            this.runTestCase(TEST_VECTORS[i]);
        }
        this.randomTests();
    }

    private void runTestCase(String[] stringArray) throws InvalidCipherTextException {
        for (int i = 12; i <= 16; ++i) {
            this.runTestCase(stringArray, i);
        }
    }

    private void runTestCase(String[] stringArray, int n) throws InvalidCipherTextException {
        int n2 = 0;
        String string = stringArray[n2++];
        byte[] byArray = Hex.decode(stringArray[n2++]);
        byte[] byArray2 = Hex.decode(stringArray[n2++]);
        byte[] byArray3 = Hex.decode(stringArray[n2++]);
        byte[] byArray4 = Hex.decode(stringArray[n2++]);
        byte[] byArray5 = Hex.decode(stringArray[n2++]);
        byte[] byArray6 = Hex.decode(stringArray[n2++]);
        byte[] byArray7 = new byte[n];
        System.arraycopy(byArray6, 0, byArray7, 0, byArray7.length);
        AEADParameters aEADParameters = new AEADParameters(new KeyParameter(byArray), byArray7.length * 8, byArray4, byArray3);
        this.runTestCase(null, null, aEADParameters, string, byArray2, byArray5, byArray7);
        this.runTestCase(new BasicGCMMultiplier(), new BasicGCMMultiplier(), aEADParameters, string, byArray2, byArray5, byArray7);
        this.runTestCase(new Tables8kGCMMultiplier(), new Tables8kGCMMultiplier(), aEADParameters, string, byArray2, byArray5, byArray7);
        this.runTestCase(new Tables64kGCMMultiplier(), new Tables64kGCMMultiplier(), aEADParameters, string, byArray2, byArray5, byArray7);
    }

    private void runTestCase(GCMMultiplier gCMMultiplier, GCMMultiplier gCMMultiplier2, AEADParameters aEADParameters, String string, byte[] byArray, byte[] byArray2, byte[] byArray3) throws InvalidCipherTextException {
        GCMBlockCipher gCMBlockCipher = this.initCipher(gCMMultiplier, true, aEADParameters);
        GCMBlockCipher gCMBlockCipher2 = this.initCipher(gCMMultiplier2, false, aEADParameters);
        this.checkTestCase(gCMBlockCipher, gCMBlockCipher2, string, byArray, byArray2, byArray3);
        this.checkTestCase(gCMBlockCipher, gCMBlockCipher2, string + " (reused)", byArray, byArray2, byArray3);
    }

    private GCMBlockCipher initCipher(GCMMultiplier gCMMultiplier, boolean bl, AEADParameters aEADParameters) {
        GCMBlockCipher gCMBlockCipher = new GCMBlockCipher(new AESFastEngine(), gCMMultiplier);
        gCMBlockCipher.init(bl, aEADParameters);
        return gCMBlockCipher;
    }

    private void checkTestCase(GCMBlockCipher gCMBlockCipher, GCMBlockCipher gCMBlockCipher2, String string, byte[] byArray, byte[] byArray2, byte[] byArray3) throws InvalidCipherTextException {
        byte[] byArray4 = new byte[gCMBlockCipher.getOutputSize(byArray.length)];
        int n = gCMBlockCipher.processBytes(byArray, 0, byArray.length, byArray4, 0);
        if (byArray4.length != (n += gCMBlockCipher.doFinal(byArray4, n))) {
            this.fail("encryption reported incorrect length: " + string);
        }
        byte[] byArray5 = gCMBlockCipher.getMac();
        byte[] byArray6 = new byte[byArray.length];
        System.arraycopy(byArray4, 0, byArray6, 0, byArray6.length);
        byte[] byArray7 = new byte[byArray4.length - byArray.length];
        System.arraycopy(byArray4, byArray.length, byArray7, 0, byArray7.length);
        if (!this.areEqual(byArray2, byArray6)) {
            this.fail("incorrect encrypt in: " + string);
        }
        if (!this.areEqual(byArray3, byArray5)) {
            this.fail("getMac() returned wrong mac in: " + string);
        }
        if (!this.areEqual(byArray3, byArray7)) {
            this.fail("stream contained wrong mac in: " + string);
        }
        byte[] byArray8 = new byte[gCMBlockCipher2.getOutputSize(byArray4.length)];
        n = gCMBlockCipher2.processBytes(byArray4, 0, byArray4.length, byArray8, 0);
        n += gCMBlockCipher2.doFinal(byArray8, n);
        byArray5 = gCMBlockCipher2.getMac();
        byArray6 = new byte[byArray2.length];
        System.arraycopy(byArray8, 0, byArray6, 0, byArray6.length);
        if (!this.areEqual(byArray, byArray6)) {
            this.fail("incorrect decrypt in: " + string);
        }
    }

    private void randomTests() throws InvalidCipherTextException {
        SecureRandom secureRandom = new SecureRandom();
        for (int i = 0; i < 10; ++i) {
            this.randomTest(secureRandom, null);
            this.randomTest(secureRandom, new BasicGCMMultiplier());
            this.randomTest(secureRandom, new Tables8kGCMMultiplier());
            this.randomTest(secureRandom, new Tables64kGCMMultiplier());
        }
    }

    private void randomTest(SecureRandom secureRandom, GCMMultiplier gCMMultiplier) throws InvalidCipherTextException {
        byte[] byArray;
        int n = 16 + 8 * (Math.abs(secureRandom.nextInt()) % 3);
        byte[] byArray2 = new byte[n];
        secureRandom.nextBytes(byArray2);
        int n2 = secureRandom.nextInt() >>> 22;
        byte[] byArray3 = new byte[n2];
        secureRandom.nextBytes(byArray3);
        int n3 = secureRandom.nextInt() >>> 22;
        byte[] byArray4 = new byte[n3];
        secureRandom.nextBytes(byArray4);
        int n4 = 1 + (secureRandom.nextInt() >>> 22);
        byte[] byArray5 = new byte[n4];
        secureRandom.nextBytes(byArray5);
        GCMBlockCipher gCMBlockCipher = new GCMBlockCipher(new AESFastEngine(), gCMMultiplier);
        AEADParameters aEADParameters = new AEADParameters(new KeyParameter(byArray2), 128, byArray5, byArray4);
        gCMBlockCipher.init(true, aEADParameters);
        byte[] byArray6 = new byte[gCMBlockCipher.getOutputSize(byArray3.length)];
        int n5 = gCMBlockCipher.processBytes(byArray3, 0, byArray3.length, byArray6, 0);
        n5 += gCMBlockCipher.doFinal(byArray6, n5);
        if (byArray6.length != n5) {
            this.fail("encryption reported incorrect length in randomised test");
        }
        byte[] byArray7 = gCMBlockCipher.getMac();
        byte[] byArray8 = new byte[byArray6.length - byArray3.length];
        System.arraycopy(byArray6, byArray3.length, byArray8, 0, byArray8.length);
        if (!this.areEqual(byArray7, byArray8)) {
            this.fail("stream contained wrong mac in randomised test");
        }
        gCMBlockCipher.init(false, aEADParameters);
        byte[] byArray9 = new byte[gCMBlockCipher.getOutputSize(byArray6.length)];
        n5 = gCMBlockCipher.processBytes(byArray6, 0, byArray6.length, byArray9, 0);
        n5 += gCMBlockCipher.doFinal(byArray9, n5);
        if (!this.areEqual(byArray3, byArray9)) {
            this.fail("incorrect decrypt in randomised test");
        }
        if (!this.areEqual(byArray7, byArray = gCMBlockCipher.getMac())) {
            this.fail("decryption produced different mac from encryption");
        }
    }

    public static void main(String[] stringArray) {
        GCMTest.runTest(new GCMTest());
    }
}

