/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.test;

import edu.illinois.ncsa.bouncycastle.crypto.CipherParameters;
import edu.illinois.ncsa.bouncycastle.crypto.engines.Grain128Engine;
import edu.illinois.ncsa.bouncycastle.crypto.params.KeyParameter;
import edu.illinois.ncsa.bouncycastle.crypto.params.ParametersWithIV;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;

public class Grain128Test
extends SimpleTest {
    String keyStream1 = "f09b7bf7d7f6b5c2de2ffc73ac21397f";
    String keyStream2 = "afb5babfa8de896b4b9c6acaf7c4fbfd";

    public String getName() {
        return "Grain-128";
    }

    public void performTest() {
        this.Grain128Test1(new ParametersWithIV(new KeyParameter(Hex.decode("00000000000000000000000000000000")), Hex.decode("000000000000000000000000")));
        this.Grain128Test2(new ParametersWithIV(new KeyParameter(Hex.decode("0123456789abcdef123456789abcdef0")), Hex.decode("0123456789abcdef12345678")));
        this.Grain128Test3(new ParametersWithIV(new KeyParameter(Hex.decode("0123456789abcdef123456789abcdef0")), Hex.decode("0123456789abcdef12345678")));
    }

    private void Grain128Test1(CipherParameters cipherParameters) {
        Grain128Engine grain128Engine = new Grain128Engine();
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[16];
        grain128Engine.init(true, cipherParameters);
        grain128Engine.processBytes(byArray, 0, byArray.length, byArray2, 0);
        if (!this.areEqual(byArray2, Hex.decode(this.keyStream1))) {
            this.mismatch("Keystream 1", this.keyStream1, byArray2);
        }
        grain128Engine.reset();
        grain128Engine.processBytes(byArray, 0, byArray.length, byArray2, 0);
        if (!this.areEqual(byArray2, Hex.decode(this.keyStream1))) {
            this.mismatch("Keystream 1", this.keyStream1, byArray2);
        }
    }

    private void Grain128Test2(CipherParameters cipherParameters) {
        Grain128Engine grain128Engine = new Grain128Engine();
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[16];
        grain128Engine.init(true, cipherParameters);
        grain128Engine.processBytes(byArray, 0, byArray.length, byArray2, 0);
        if (!this.areEqual(byArray2, Hex.decode(this.keyStream2))) {
            this.mismatch("Keystream 2", this.keyStream2, byArray2);
        }
        grain128Engine.reset();
        grain128Engine.processBytes(byArray, 0, byArray.length, byArray2, 0);
        if (!this.areEqual(byArray2, Hex.decode(this.keyStream2))) {
            this.mismatch("Keystream 2", this.keyStream2, byArray2);
        }
    }

    private void Grain128Test3(CipherParameters cipherParameters) {
        Grain128Engine grain128Engine = new Grain128Engine();
        byte[] byArray = "Encrypt me!".getBytes();
        byte[] byArray2 = new byte[byArray.length];
        byte[] byArray3 = new byte[byArray.length];
        grain128Engine.init(true, cipherParameters);
        grain128Engine.processBytes(byArray, 0, byArray.length, byArray2, 0);
        grain128Engine.reset();
        grain128Engine.processBytes(byArray2, 0, byArray2.length, byArray3, 0);
        if (!this.areEqual(byArray, byArray3)) {
            this.mismatch("Test 3", new String(Hex.encode(byArray)), byArray3);
        }
    }

    private void mismatch(String string, String string2, byte[] byArray) {
        this.fail("mismatch on " + string, string2, new String(Hex.encode(byArray)));
    }

    public static void main(String[] stringArray) {
        Grain128Test.runTest(new Grain128Test());
    }
}

