/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.test;

import edu.illinois.ncsa.bouncycastle.crypto.AsymmetricCipherKeyPair;
import edu.illinois.ncsa.bouncycastle.crypto.InvalidCipherTextException;
import edu.illinois.ncsa.bouncycastle.crypto.engines.NaccacheSternEngine;
import edu.illinois.ncsa.bouncycastle.crypto.generators.NaccacheSternKeyPairGenerator;
import edu.illinois.ncsa.bouncycastle.crypto.params.NaccacheSternKeyGenerationParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.NaccacheSternKeyParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.NaccacheSternPrivateKeyParameters;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Vector;

public class NaccacheSternTest
extends SimpleTest {
    static final boolean debug = false;
    static final NaccacheSternEngine cryptEng = new NaccacheSternEngine();
    static final NaccacheSternEngine decryptEng = new NaccacheSternEngine();
    static final BigInteger a;
    static final BigInteger u1;
    static final BigInteger u2;
    static final BigInteger u3;
    static final BigInteger b;
    static final BigInteger v1;
    static final BigInteger v2;
    static final BigInteger v3;
    static final BigInteger ONE;
    static final BigInteger TWO;
    static final BigInteger sigma;
    static final BigInteger p;
    static final BigInteger q;
    static final BigInteger n;
    static final BigInteger phi_n;
    static final BigInteger g;
    static final Vector smallPrimes;
    static final String input = "4e6f77206973207468652074696d6520666f7220616c6c20676f6f64206d656e";
    static final BigInteger paperTest;
    static final String edgeInput = "ff6f77206973207468652074696d6520666f7220616c6c20676f6f64206d656e";

    public String getName() {
        return "NaccacheStern";
    }

    public void performTest() {
        smallPrimes.addElement(u1);
        smallPrimes.addElement(u2);
        smallPrimes.addElement(u3);
        smallPrimes.addElement(v1);
        smallPrimes.addElement(v2);
        smallPrimes.addElement(v3);
        NaccacheSternKeyParameters naccacheSternKeyParameters = new NaccacheSternKeyParameters(false, g, n, sigma.bitLength());
        NaccacheSternPrivateKeyParameters naccacheSternPrivateKeyParameters = new NaccacheSternPrivateKeyParameters(g, n, sigma.bitLength(), smallPrimes, phi_n);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = new AsymmetricCipherKeyPair(naccacheSternKeyParameters, naccacheSternPrivateKeyParameters);
        cryptEng.init(true, asymmetricCipherKeyPair.getPublic());
        decryptEng.init(false, asymmetricCipherKeyPair.getPrivate());
        byte[] byArray = paperTest.toByteArray();
        if (!new BigInteger(byArray).equals(new BigInteger(this.enDeCrypt(byArray)))) {
            this.fail("failed NaccacheStern paper test");
        }
        NaccacheSternKeyGenerationParameters naccacheSternKeyGenerationParameters = new NaccacheSternKeyGenerationParameters(new SecureRandom(), 768, 8, 30, false);
        NaccacheSternKeyPairGenerator naccacheSternKeyPairGenerator = new NaccacheSternKeyPairGenerator();
        naccacheSternKeyPairGenerator.init(naccacheSternKeyGenerationParameters);
        asymmetricCipherKeyPair = naccacheSternKeyPairGenerator.generateKeyPair();
        if (((NaccacheSternKeyParameters)asymmetricCipherKeyPair.getPublic()).getModulus().bitLength() < 768) {
            System.out.println("FAILED: key size is <786 bit, exactly " + ((NaccacheSternKeyParameters)asymmetricCipherKeyPair.getPublic()).getModulus().bitLength() + " bit");
            this.fail("failed key generation (768) length test");
        }
        cryptEng.init(true, asymmetricCipherKeyPair.getPublic());
        decryptEng.init(false, asymmetricCipherKeyPair.getPrivate());
        byArray = Hex.decode(input);
        if (!new BigInteger(1, byArray).equals(new BigInteger(1, this.enDeCrypt(byArray)))) {
            this.fail("failed encryption decryption (" + naccacheSternKeyGenerationParameters.getStrength() + ") basic test");
        }
        if (!new BigInteger(1, byArray = Hex.decode(edgeInput)).equals(new BigInteger(1, this.enDeCrypt(byArray)))) {
            this.fail("failed encryption decryption (" + naccacheSternKeyGenerationParameters.getStrength() + ") edgeInput test");
        }
        try {
            new NaccacheSternEngine().processBlock(new byte[]{1}, 0, 1);
            this.fail("failed initialisation check");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            this.fail("failed initialisation check");
        }
    }

    private byte[] enDeCrypt(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        try {
            byArray2 = cryptEng.processData(byArray2);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            this.fail("failed - exception " + invalidCipherTextException.toString() + "\n" + invalidCipherTextException.getMessage());
        }
        try {
            byArray2 = decryptEng.processData(byArray2);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            this.fail("failed - exception " + invalidCipherTextException.toString() + "\n" + invalidCipherTextException.getMessage());
        }
        return byArray2;
    }

    public static void main(String[] stringArray) {
        NaccacheSternTest.runTest(new NaccacheSternTest());
    }

    static {
        cryptEng.setDebug(false);
        decryptEng.setDebug(false);
        a = BigInteger.valueOf(101L);
        u1 = BigInteger.valueOf(3L);
        u2 = BigInteger.valueOf(5L);
        u3 = BigInteger.valueOf(7L);
        b = BigInteger.valueOf(191L);
        v1 = BigInteger.valueOf(11L);
        v2 = BigInteger.valueOf(13L);
        v3 = BigInteger.valueOf(17L);
        ONE = BigInteger.valueOf(1L);
        TWO = BigInteger.valueOf(2L);
        sigma = u1.multiply(u2).multiply(u3).multiply(v1).multiply(v2).multiply(v3);
        p = TWO.multiply(a).multiply(u1).multiply(u2).multiply(u3).add(ONE);
        q = TWO.multiply(b).multiply(v1).multiply(v2).multiply(v3).add(ONE);
        n = p.multiply(q);
        phi_n = p.subtract(ONE).multiply(q.subtract(ONE));
        g = BigInteger.valueOf(131L);
        smallPrimes = new Vector();
        paperTest = BigInteger.valueOf(202L);
    }
}

