/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.test;

import edu.illinois.ncsa.bouncycastle.crypto.engines.VMPCKSA3Engine;
import edu.illinois.ncsa.bouncycastle.crypto.params.KeyParameter;
import edu.illinois.ncsa.bouncycastle.crypto.params.ParametersWithIV;
import edu.illinois.ncsa.bouncycastle.util.Arrays;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;

public class VMPCKSA3Test
extends SimpleTest {
    private static final byte[] input = new byte[1000000];

    public String getName() {
        return "VMPC-KSA3";
    }

    private void checkByte(byte[] byArray, int n, byte by) {
        if (byArray[n] != by) {
            this.fail("Fail on position " + n, new String(Hex.encode(new byte[]{by})), new String(Hex.encode(new byte[]{byArray[n]})));
        }
    }

    public void performTest() {
        byte[] byArray = Hex.decode("9661410AB797D8A9EB767C21172DF6C7");
        byte[] byArray2 = Hex.decode("4B5C2F003E67F39557A8D26F3DA2B155");
        KeyParameter keyParameter = new KeyParameter(byArray);
        ParametersWithIV parametersWithIV = new ParametersWithIV(keyParameter, byArray2);
        VMPCKSA3Engine vMPCKSA3Engine = new VMPCKSA3Engine();
        try {
            vMPCKSA3Engine.init(true, keyParameter);
            this.fail("init failed to throw expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        vMPCKSA3Engine.init(true, parametersWithIV);
        this.checkEngine(vMPCKSA3Engine);
        vMPCKSA3Engine.reset();
        byte[] byArray3 = this.checkEngine(vMPCKSA3Engine);
        vMPCKSA3Engine.init(false, parametersWithIV);
        byte[] byArray4 = new byte[byArray3.length];
        vMPCKSA3Engine.processBytes(byArray3, 0, byArray3.length, byArray4, 0);
        if (!Arrays.areEqual(input, byArray4)) {
            this.fail("decrypted bytes differ from original bytes");
        }
    }

    private byte[] checkEngine(VMPCKSA3Engine vMPCKSA3Engine) {
        byte[] byArray = new byte[input.length];
        vMPCKSA3Engine.processBytes(input, 0, byArray.length, byArray, 0);
        this.checkByte(byArray, 0, (byte)-74);
        this.checkByte(byArray, 1, (byte)-21);
        this.checkByte(byArray, 2, (byte)-82);
        this.checkByte(byArray, 3, (byte)-2);
        this.checkByte(byArray, 252, (byte)72);
        this.checkByte(byArray, 253, (byte)23);
        this.checkByte(byArray, 254, (byte)36);
        this.checkByte(byArray, 255, (byte)115);
        this.checkByte(byArray, 1020, (byte)29);
        this.checkByte(byArray, 1021, (byte)-82);
        this.checkByte(byArray, 1022, (byte)-61);
        this.checkByte(byArray, 1023, (byte)90);
        this.checkByte(byArray, 102396, (byte)29);
        this.checkByte(byArray, 102397, (byte)-89);
        this.checkByte(byArray, 102398, (byte)-31);
        this.checkByte(byArray, 102399, (byte)-36);
        return byArray;
    }

    public static void main(String[] stringArray) {
        VMPCKSA3Test.runTest(new VMPCKSA3Test());
    }
}

