/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.tls;

import edu.illinois.ncsa.bouncycastle.crypto.BlockCipher;
import edu.illinois.ncsa.bouncycastle.crypto.Digest;
import edu.illinois.ncsa.bouncycastle.crypto.digests.MD5Digest;
import edu.illinois.ncsa.bouncycastle.crypto.digests.SHA1Digest;
import edu.illinois.ncsa.bouncycastle.crypto.digests.SHA256Digest;
import edu.illinois.ncsa.bouncycastle.crypto.digests.SHA384Digest;
import edu.illinois.ncsa.bouncycastle.crypto.engines.AESFastEngine;
import edu.illinois.ncsa.bouncycastle.crypto.engines.DESedeEngine;
import edu.illinois.ncsa.bouncycastle.crypto.modes.CBCBlockCipher;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsBlockCipher;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsCipher;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsCipherFactory;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsClientContext;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsFatalAlert;
import java.io.IOException;

public class DefaultTlsCipherFactory
implements TlsCipherFactory {
    public TlsCipher createCipher(TlsClientContext tlsClientContext, int n, int n2) throws IOException {
        switch (n) {
            case 7: {
                return this.createDESedeCipher(tlsClientContext, 24, n2);
            }
            case 8: {
                return this.createAESCipher(tlsClientContext, 16, n2);
            }
            case 9: {
                return this.createAESCipher(tlsClientContext, 32, n2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsCipher createAESCipher(TlsClientContext tlsClientContext, int n, int n2) throws IOException {
        return new TlsBlockCipher(tlsClientContext, this.createAESBlockCipher(), this.createAESBlockCipher(), this.createDigest(n2), this.createDigest(n2), n);
    }

    protected TlsCipher createDESedeCipher(TlsClientContext tlsClientContext, int n, int n2) throws IOException {
        return new TlsBlockCipher(tlsClientContext, this.createDESedeBlockCipher(), this.createDESedeBlockCipher(), this.createDigest(n2), this.createDigest(n2), n);
    }

    protected BlockCipher createAESBlockCipher() {
        return new CBCBlockCipher(new AESFastEngine());
    }

    protected BlockCipher createDESedeBlockCipher() {
        return new CBCBlockCipher(new DESedeEngine());
    }

    protected Digest createDigest(int n) throws IOException {
        switch (n) {
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA256Digest();
            }
            case 4: {
                return new SHA384Digest();
            }
        }
        throw new TlsFatalAlert(80);
    }
}

