/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.tls;

import edu.illinois.ncsa.bouncycastle.crypto.tls.CombinedHash;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsCipher;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsCompression;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsNullCipher;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsNullCompression;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsProtocolHandler;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class RecordStream {
    private TlsProtocolHandler handler;
    private InputStream is;
    private OutputStream os;
    private byte[] handshake_messages;
    private TlsCompression readCompression = null;
    private TlsCompression writeCompression = null;
    private TlsCipher readCipher = null;
    private TlsCipher writeCipher = null;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    RecordStream(TlsProtocolHandler tlsProtocolHandler, InputStream inputStream, OutputStream outputStream) {
        this.handler = tlsProtocolHandler;
        this.is = inputStream;
        this.os = outputStream;
        this.handshake_messages = new byte[0];
        this.writeCompression = this.readCompression = new TlsNullCompression();
        this.writeCipher = this.readCipher = new TlsNullCipher();
    }

    void clientCipherSpecDecided(TlsCompression tlsCompression, TlsCipher tlsCipher) {
        this.writeCompression = tlsCompression;
        this.writeCipher = tlsCipher;
    }

    void serverClientSpecReceived() {
        this.readCompression = this.writeCompression;
        this.readCipher = this.writeCipher;
    }

    public void readData() throws IOException {
        int n = this.is.available();
        if (n < 5) {
            this.handler.incHandshakeBlocking(5 - n);
        }
        short s = TlsUtils.readUint8(this.is);
        this.handler.checkVersion(this.is);
        int n2 = TlsUtils.readUint16(this.is);
        n = this.is.available();
        if (n < n2) {
            this.handler.incHandshakeBlocking(n2 - n);
        }
        byte[] byArray = this.decodeAndVerify(s, this.is, n2);
        this.handler.processData(s, byArray, 0, byArray.length);
    }

    protected byte[] decodeAndVerify(short s, InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        TlsUtils.readFully(byArray, inputStream);
        byte[] byArray2 = this.readCipher.decodeCiphertext(s, byArray, 0, byArray.length);
        OutputStream outputStream = this.readCompression.decompress(this.buffer);
        if (outputStream == this.buffer) {
            return byArray2;
        }
        outputStream.write(byArray2, 0, byArray2.length);
        outputStream.flush();
        return this.getBufferContents();
    }

    protected void writeMessage(short s, byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2;
        byte[] byArray3;
        OutputStream outputStream;
        if (s == 22) {
            this.updateHandshakeData(byArray, n, n2);
        }
        if ((outputStream = this.writeCompression.compress(this.buffer)) == this.buffer) {
            byArray3 = this.writeCipher.encodePlaintext(s, byArray, n, n2);
        } else {
            outputStream.write(byArray, n, n2);
            outputStream.flush();
            byArray2 = this.getBufferContents();
            byArray3 = this.writeCipher.encodePlaintext(s, byArray2, 0, byArray2.length);
        }
        byArray2 = new byte[byArray3.length + 5];
        TlsUtils.writeUint8(s, byArray2, 0);
        this.handler.writeVersion(byArray2, 1);
        TlsUtils.writeUint16(byArray3.length, byArray2, 3);
        System.arraycopy(byArray3, 0, byArray2, 5, byArray3.length);
        this.os.write(byArray2);
        this.os.flush();
    }

    void updateHandshakeData(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[this.handshake_messages.length + n2];
        System.arraycopy(this.handshake_messages, 0, byArray2, 0, this.handshake_messages.length);
        System.arraycopy(byArray, n, byArray2, this.handshake_messages.length, n2);
        this.handshake_messages = byArray2;
    }

    byte[] getHandshakeMessages() {
        return this.handshake_messages;
    }

    protected void close() throws IOException {
        IOException iOException = null;
        try {
            this.is.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        try {
            this.os.close();
        }
        catch (IOException iOException3) {
            iOException = iOException3;
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    protected void flush() throws IOException {
        this.os.flush();
    }

    private byte[] getBufferContents() {
        byte[] byArray = this.buffer.toByteArray();
        this.buffer.reset();
        return byArray;
    }

    private static byte[] doFinal(CombinedHash combinedHash) {
        byte[] byArray = new byte[combinedHash.getDigestSize()];
        combinedHash.doFinal(byArray, 0);
        return byArray;
    }
}

