/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.tls;

import edu.illinois.ncsa.bouncycastle.crypto.Digest;
import edu.illinois.ncsa.bouncycastle.crypto.Mac;
import edu.illinois.ncsa.bouncycastle.crypto.macs.HMac;
import edu.illinois.ncsa.bouncycastle.crypto.macs.SSL3HMac;
import edu.illinois.ncsa.bouncycastle.crypto.params.KeyParameter;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsClientContext;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsProtocolVersion;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class TlsMac {
    TlsClientContext context;
    protected long seqNo;
    protected Mac mac;
    protected byte[] secret;

    public TlsMac(TlsClientContext tlsClientContext, Digest digest, byte[] byArray, int n, int n2) {
        this.context = tlsClientContext;
        this.mac = tlsClientContext.getNegotiatedVersion() == TlsProtocolVersion.SSLv3 ? new SSL3HMac(digest) : new HMac(digest);
        this.secret = new byte[n2];
        System.arraycopy(byArray, n, this.secret, 0, n2);
        KeyParameter keyParameter = new KeyParameter(byArray, n, n2);
        this.mac.init(keyParameter);
        this.seqNo = 0L;
    }

    public byte[] getMACSecret() {
        return this.secret;
    }

    public long getSequenceNumber() {
        return this.seqNo;
    }

    public void incSequence() {
        ++this.seqNo;
    }

    public int getSize() {
        return this.mac.getMacSize();
    }

    public byte[] calculateMac(short s, byte[] byArray, int n, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = this.context.getNegotiatedVersion() == TlsProtocolVersion.SSLv3 ? new ByteArrayOutputStream(11) : new ByteArrayOutputStream(13);
        try {
            TlsUtils.writeUint64(this.seqNo++, byteArrayOutputStream);
            TlsUtils.writeUint8(s, byteArrayOutputStream);
            if (this.context.getNegotiatedVersion() != TlsProtocolVersion.SSLv3) {
                this.context.writeVersion(byteArrayOutputStream);
            }
            TlsUtils.writeUint16(n2, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Internal error during mac calculation");
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        this.mac.update(byArray2, 0, byArray2.length);
        this.mac.update(byArray, n, n2);
        byte[] byArray3 = new byte[this.mac.getMacSize()];
        this.mac.doFinal(byArray3, 0);
        return byArray3;
    }
}

