/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.tls.test;

import edu.illinois.ncsa.bouncycastle.crypto.tls.AlwaysValidVerifyer;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsProtocolHandler;
import edu.illinois.ncsa.bouncycastle.crypto.tls.test.HTTPSServerThread;
import edu.illinois.ncsa.bouncycastle.util.Arrays;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BasicTlsTest
extends TestCase {
    private static final int PORT_NO = 8003;

    public void testConnection() throws Exception {
        HTTPSServerThread hTTPSServerThread = new HTTPSServerThread();
        hTTPSServerThread.start();
        Thread.yield();
        AlwaysValidVerifyer alwaysValidVerifyer = new AlwaysValidVerifyer();
        Socket socket = null;
        for (int i = 0; socket == null && i != 3; ++i) {
            Thread.sleep(1000L);
            try {
                socket = new Socket("localhost", 8003);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (socket == null) {
            throw new IOException("unable to connect");
        }
        TlsProtocolHandler tlsProtocolHandler = new TlsProtocolHandler(socket.getInputStream(), socket.getOutputStream());
        tlsProtocolHandler.connect(alwaysValidVerifyer);
        InputStream inputStream = tlsProtocolHandler.getInputStream();
        OutputStream outputStream = tlsProtocolHandler.getOutputStream();
        outputStream.write("GET / HTTP/1.1\r\n\r\n".getBytes());
        byte[] byArray = new byte[4096];
        int n = 0;
        int n2 = 0;
        while ((n = inputStream.read(byArray, n2, byArray.length - n2)) > 0) {
            n2 += n;
        }
        inputStream.close();
        byte[] byArray2 = Hex.decode("485454502f312e3120323030204f4b0d0a436f6e74656e742d547970653a20746578742f68746d6c0d0a0d0a3c68746d6c3e0d0a3c626f64793e0d0a48656c6c6f20576f726c64210d0a3c2f626f64793e0d0a3c2f68746d6c3e0d0a");
        BasicTlsTest.assertEquals((int)n2, (int)byArray2.length);
        byte[] byArray3 = new byte[byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        BasicTlsTest.assertTrue((boolean)Arrays.areEqual(byArray2, byArray3));
    }

    public static TestSuite suite() {
        return new TestSuite(BasicTlsTest.class);
    }

    public static void main(String[] stringArray) throws Exception {
        TestRunner.run((Test)BasicTlsTest.suite());
    }
}

