/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.commons.math3.linear;

import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.linear.AbstractRealMatrix;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Mutate2D;
import org.ojalgo.matrix.store.RawStore;

public class Access2DWrapper
extends AbstractRealMatrix {
    private final Access2D<?> myAccess2D;

    public static Access2DWrapper of(Access2D<?> delegate) {
        return new Access2DWrapper(delegate);
    }

    Access2DWrapper(Access2D<?> delegate) {
        this.myAccess2D = delegate;
    }

    public Array2DRowRealMatrix copy() {
        return new Array2DRowRealMatrix(this.myAccess2D.toRawCopy2D(), false);
    }

    public Access2DWrapper createMatrix(int rowDimension, int columnDimension) throws NotStrictlyPositiveException {
        return new Access2DWrapper((Access2D)RawStore.FACTORY.makeZero((long)rowDimension, (long)columnDimension));
    }

    public int getColumnDimension() {
        return (int)this.myAccess2D.countColumns();
    }

    public double getEntry(int row, int column) throws OutOfRangeException {
        return this.myAccess2D.doubleValue((long)row, (long)column);
    }

    public int getRowDimension() {
        return (int)this.myAccess2D.countRows();
    }

    public void setEntry(int row, int column, double value) throws OutOfRangeException {
        if (!(this.myAccess2D instanceof Mutate2D)) {
            throw new UnsupportedOperationException();
        }
        ((Mutate2D)this.myAccess2D).set((long)row, (long)column, value);
    }
}

