/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.commons.math3.linear;

import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.DiagonalMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.RawStore;

public abstract class RealMatrixWrapper
implements MatrixStore<Double> {
    private final RealMatrix myRealMatrix;

    public static RealMatrixWrapper of(RealMatrix delegate) {
        if (delegate instanceof Array2DRowRealMatrix) {
            return new Array2DRowWrapper((Array2DRowRealMatrix)delegate);
        }
        if (delegate instanceof DiagonalMatrix) {
            return new DiagonalWrapper((DiagonalMatrix)delegate);
        }
        return new DefaultWrapper(delegate);
    }

    RealMatrixWrapper(RealMatrix delegate) {
        this.myRealMatrix = delegate;
    }

    public long countColumns() {
        return this.myRealMatrix.getColumnDimension();
    }

    public long countRows() {
        return this.myRealMatrix.getRowDimension();
    }

    public double doubleValue(long row, long col) {
        return this.myRealMatrix.getEntry((int)row, (int)col);
    }

    public Double get(long row, long col) {
        return this.myRealMatrix.getEntry((int)row, (int)col);
    }

    public PhysicalStore.Factory<Double, ?> physical() {
        return PrimitiveDenseStore.FACTORY;
    }

    static final class DiagonalWrapper
    extends RealMatrixWrapper {
        private final DiagonalMatrix myDiagonal;

        DiagonalWrapper(DiagonalMatrix delegate) {
            super((RealMatrix)delegate);
            this.myDiagonal = delegate;
        }

        public int firstInColumn(int col) {
            return col;
        }

        public int firstInRow(int row) {
            return row;
        }

        public int limitOfColumn(int col) {
            return col + 1;
        }

        public int limitOfRow(int row) {
            return row + 1;
        }

        public void supplyTo(ElementsConsumer<Double> receiver) {
            receiver.fillAll((Number)PrimitiveMath.ZERO);
            double[] diagonal = this.myDiagonal.getDataRef();
            for (int ij = 0; ij < diagonal.length; ++ij) {
                receiver.set((long)ij, (long)ij, diagonal[ij]);
            }
        }
    }

    static final class DefaultWrapper
    extends RealMatrixWrapper {
        DefaultWrapper(RealMatrix delegate) {
            super(delegate);
        }

        public void supplyTo(ElementsConsumer<Double> receiver) {
            long tmpLimRows = Math.min(this.countRows(), receiver.countRows());
            long tmpLimCols = Math.min(this.countColumns(), receiver.countColumns());
            for (long j = 0L; j < tmpLimCols; ++j) {
                for (long i = 0L; i < tmpLimRows; ++i) {
                    receiver.set(i, j, this.doubleValue(i, j));
                }
            }
        }
    }

    static final class Array2DRowWrapper
    extends RealMatrixWrapper {
        private final Array2DRowRealMatrix myArray2DRow;

        Array2DRowWrapper(Array2DRowRealMatrix delegate) {
            super((RealMatrix)delegate);
            this.myArray2DRow = delegate;
        }

        @Override
        public PhysicalStore.Factory<Double, ?> physical() {
            return RawStore.FACTORY;
        }

        public void supplyTo(ElementsConsumer<Double> receiver) {
            int tmpLimRows = (int)Math.min((long)this.myArray2DRow.getRowDimension(), receiver.countRows());
            int tmpLimCols = (int)Math.min((long)this.myArray2DRow.getColumnDimension(), receiver.countColumns());
            for (int i = 0; i < tmpLimRows; ++i) {
                for (int j = 0; j < tmpLimCols; ++j) {
                    receiver.set((long)i, (long)j, this.myArray2DRow.getEntry(i, j));
                }
            }
        }
    }
}

