/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mondrian.xmla.Enumeration;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaRequestCallback;
import mondrian.xmla.XmlaServlet;
import mondrian.xmla.XmlaUtil;
import mondrian.xmla.impl.DefaultSaxWriter;
import mondrian.xmla.impl.DefaultXmlaRequest;
import mondrian.xmla.impl.DefaultXmlaResponse;
import org.olap4j.impl.Olap4jUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultXmlaServlet
extends XmlaServlet {
    protected static final String nl = System.getProperty("line.separator");
    private static final String REQUIRE_AUTHENTICATED_SESSIONS = "requireAuthenticatedSessions";
    private DocumentBuilderFactory domFactory = null;
    private boolean requireAuthenticatedSessions = false;
    private final Map<String, SessionInfo> sessionInfos = new HashMap<String, SessionInfo>();

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.domFactory = DefaultXmlaServlet.getDocumentBuilderFactory();
        this.requireAuthenticatedSessions = Boolean.parseBoolean(servletConfig.getInitParameter(REQUIRE_AUTHENTICATED_SESSIONS));
    }

    protected static DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        return factory;
    }

    @Override
    protected void unmarshallSoapMessage(HttpServletRequest request, Element[] requestSoapParts) throws XmlaException {
        try {
            Document soapDoc;
            DocumentBuilder domBuilder;
            ServletInputStream inputStream;
            try {
                inputStream = request.getInputStream();
            }
            catch (IllegalStateException ex) {
                throw new XmlaException("Server", "00USMA01", "Request input method invoked at illegal time", ex);
            }
            catch (IOException ex) {
                throw new XmlaException("Server", "00USMA02", "Request input Exception occurred", ex);
            }
            try {
                domBuilder = this.domFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                throw new XmlaException("Server", "00USMB01", "DocumentBuilder cannot be created which satisfies the configuration requested", ex);
            }
            try {
                soapDoc = domBuilder.parse(new InputSource((InputStream)inputStream));
            }
            catch (IOException ex) {
                throw new XmlaException("Server", "00USMC01", "DOM parse IO errors occur", ex);
            }
            catch (SAXException ex) {
                throw new XmlaException("Client", "00USMC02", "DOM parse errors occur", ex);
            }
            Element envElem = soapDoc.getDocumentElement();
            if (LOGGER.isDebugEnabled()) {
                this.logXmlaRequest(envElem);
            }
            if ("Envelope".equals(envElem.getLocalName())) {
                if (!"http://schemas.xmlsoap.org/soap/envelope/".equals(envElem.getNamespaceURI())) {
                    throw new XmlaException("Client", "00USMC02", "DOM parse errors occur", new SAXException("Invalid SOAP message: Envelope element not in SOAP namespace"));
                }
            } else {
                throw new XmlaException("Client", "00USMC02", "DOM parse errors occur", new SAXException("Invalid SOAP message: Top element not Envelope"));
            }
            Element[] childs = XmlaUtil.filterChildElements(envElem, "http://schemas.xmlsoap.org/soap/envelope/", "Header");
            if (childs.length > 1) {
                throw new XmlaException("Client", "00USMC02", "DOM parse errors occur", new SAXException("Invalid SOAP message: More than one Header elements"));
            }
            requestSoapParts[0] = childs.length == 1 ? childs[0] : null;
            childs = XmlaUtil.filterChildElements(envElem, "http://schemas.xmlsoap.org/soap/envelope/", "Body");
            if (childs.length != 1) {
                throw new XmlaException("Client", "00USMC02", "DOM parse errors occur", new SAXException("Invalid SOAP message: Does not have one Body element"));
            }
            requestSoapParts[1] = childs[0];
        }
        catch (XmlaException xex) {
            throw xex;
        }
        catch (Exception ex) {
            throw new XmlaException("Server", "00USMU01", "Unknown error unmarshalling soap message", ex);
        }
    }

    protected void logXmlaRequest(Element envElem) {
        StringWriter writer = new StringWriter();
        writer.write("XML/A request content");
        writer.write(nl);
        XmlaUtil.element2Text(envElem, writer);
        LOGGER.debug((Object)writer.toString());
    }

    @Override
    protected void handleSoapHeader(HttpServletResponse response, Element[] requestSoapParts, byte[][] responseSoapParts, Map<String, Object> context) throws XmlaException {
        try {
            Element hdrElem = requestSoapParts[0];
            if (hdrElem == null || !hdrElem.hasChildNodes()) {
                return;
            }
            String encoding = response.getCharacterEncoding();
            byte[] bytes = null;
            NodeList nlst = hdrElem.getChildNodes();
            int nlen = nlst.getLength();
            boolean authenticatedSession = false;
            boolean beginSession = false;
            for (int i = 0; i < nlen; ++i) {
                String sessionIdStr;
                boolean mustUnderstandValue;
                Node n = nlst.item(i);
                if (!(n instanceof Element)) continue;
                Element e = (Element)n;
                String localName = e.getLocalName();
                if (localName.equals("Security") && "http://schemas.xmlsoap.org/ws/2002/04/secext".equals(e.getNamespaceURI())) {
                    NodeList childNodes = e.getChildNodes();
                    Element userNameToken = (Element)childNodes.item(1);
                    NodeList userNamePassword = userNameToken.getChildNodes();
                    Element username = (Element)userNamePassword.item(1);
                    Element password = (Element)userNamePassword.item(3);
                    String userNameStr = username.getChildNodes().item(0).getNodeValue();
                    context.put("username", userNameStr);
                    String passwordStr = "";
                    if (password.getChildNodes().item(0) != null) {
                        passwordStr = password.getChildNodes().item(0).getNodeValue();
                    }
                    context.put("password", passwordStr);
                    if ("".equals(passwordStr) || null == passwordStr) {
                        LOGGER.warn((Object)("Security header for user [" + userNameStr + "] provided without password"));
                    }
                    authenticatedSession = true;
                    continue;
                }
                Attr attr = e.getAttributeNode("mustUnderstand");
                boolean bl = mustUnderstandValue = attr != null && attr.getValue() != null && attr.getValue().equals("1");
                if (!mustUnderstandValue || !"urn:schemas-microsoft-com:xml-analysis".equals(e.getNamespaceURI())) continue;
                if (localName.equals("BeginSession")) {
                    sessionIdStr = this.generateSessionId(context);
                    context.put("session_id", sessionIdStr);
                    context.put("SessionState", "SessionStateBegin");
                } else if (localName.equals("Session")) {
                    sessionIdStr = DefaultXmlaServlet.getSessionIdFromRequest(e, context);
                    SessionInfo sessionInfo = this.getSessionInfo(sessionIdStr);
                    if (sessionInfo != null) {
                        context.put("username", sessionInfo.user);
                        context.put("password", sessionInfo.password);
                    }
                    context.put("session_id", sessionIdStr);
                    context.put("SessionState", "SessionStateWithin");
                } else if (localName.equals("EndSession")) {
                    sessionIdStr = DefaultXmlaServlet.getSessionIdFromRequest(e, context);
                    context.put("SessionState", "SessionStateEnd");
                } else {
                    String msg = "Invalid XML/A message: Unknown \"mustUnderstand\" XMLA Header element \"" + localName + "\"";
                    throw new XmlaException("MustUnderstand", "00HSHA01", "SOAP Header must understand element not recognized", new RuntimeException(msg));
                }
                StringBuilder buf = new StringBuilder(100);
                buf.append("<Session ");
                buf.append("SessionId");
                buf.append("=\"");
                buf.append(sessionIdStr);
                buf.append("\" ");
                buf.append("xmlns=\"");
                buf.append("urn:schemas-microsoft-com:xml-analysis");
                buf.append("\" />");
                bytes = buf.toString().getBytes(encoding);
                if (authenticatedSession) {
                    String username = (String)context.get("username");
                    String password = (String)context.get("password");
                    String sessionId = (String)context.get("session_id");
                    LOGGER.debug((Object)("New authenticated session; storing credentials [" + username + "/********] for session id [" + sessionId + "]"));
                    this.saveSessionInfo(username, password, sessionId);
                    continue;
                }
                if (!beginSession || !this.requireAuthenticatedSessions) continue;
                throw new XmlaException("Client", "00CHHA02", "Error in Callback processHttpHeader Authorization", new Exception("Session Credentials NOT PROVIDED"));
            }
            responseSoapParts[0] = bytes;
        }
        catch (XmlaException xex) {
            throw xex;
        }
        catch (Exception ex) {
            throw new XmlaException("Server", "00HSHU01", "Unknown error handle soap header", ex);
        }
    }

    protected String generateSessionId(Map<String, Object> context) {
        for (XmlaRequestCallback callback : this.getCallbacks()) {
            String sessionId = callback.generateSessionId(context);
            if (sessionId == null) continue;
            return sessionId;
        }
        return Long.toString(17L * System.nanoTime() + 3L * System.currentTimeMillis(), 35);
    }

    private static String getSessionIdFromRequest(Element e, Map<String, Object> context) throws Exception {
        Attr attr = e.getAttributeNode("SessionId");
        if (attr == null) {
            throw new SAXException("Invalid XML/A message: Session Header element with no SessionId attribute");
        }
        String sessionId = attr.getValue();
        if (sessionId == null) {
            throw new SAXException("Invalid XML/A message: Session Header element with SessionId attribute but no attribute value");
        }
        return sessionId;
    }

    @Override
    protected void handleSoapBody(HttpServletResponse response, Element[] requestSoapParts, byte[][] responseSoapParts, Map<String, Object> context) throws XmlaException {
        try {
            String encoding = response.getCharacterEncoding();
            Element hdrElem = requestSoapParts[0];
            Element bodyElem = requestSoapParts[1];
            Element[] dreqs = XmlaUtil.filterChildElements(bodyElem, "urn:schemas-microsoft-com:xml-analysis", "Discover");
            Element[] ereqs = XmlaUtil.filterChildElements(bodyElem, "urn:schemas-microsoft-com:xml-analysis", "Execute");
            if (dreqs.length + ereqs.length != 1) {
                throw new XmlaException("Client", "00HSBA01", "SOAP Body not correctly formed", new RuntimeException("Invalid XML/A message: Body has " + dreqs.length + " Discover Requests and " + ereqs.length + " Execute Requests"));
            }
            Element xmlaReqElem = dreqs.length == 0 ? ereqs[0] : dreqs[0];
            ByteArrayOutputStream osBuf = new ByteArrayOutputStream();
            String roleName = (String)context.get("role_name");
            String username = (String)context.get("username");
            String password = (String)context.get("password");
            String sessionId = (String)context.get("session_id");
            DefaultXmlaRequest xmlaReq = new DefaultXmlaRequest(xmlaReqElem, roleName, username, password, sessionId);
            Enumeration.ResponseMimeType responseMimeType = Enumeration.ResponseMimeType.SOAP;
            String responseMimeTypeName = xmlaReq.getProperties().get("ResponseMimeType");
            if (responseMimeTypeName != null && (responseMimeType = Enumeration.ResponseMimeType.MAP.get(responseMimeTypeName)) != null) {
                context.put("language", (Object)responseMimeType);
            }
            DefaultXmlaResponse xmlaRes = new DefaultXmlaResponse(osBuf, encoding, responseMimeType);
            try {
                this.getXmlaHandler().process(xmlaReq, xmlaRes);
            }
            catch (XmlaException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new XmlaException("Server", "00HSBB01", "XMLA SOAP Body processing error", ex);
            }
            responseSoapParts[1] = osBuf.toByteArray();
        }
        catch (XmlaException xex) {
            throw xex;
        }
        catch (Exception ex) {
            throw new XmlaException("Server", "00HSBU01", "Unknown error handle soap body", ex);
        }
    }

    @Override
    protected void marshallSoapMessage(HttpServletResponse response, byte[][] responseSoapParts, Enumeration.ResponseMimeType responseMimeType) throws XmlaException {
        try {
            StringBuilder buf;
            String encoding;
            String string = encoding = this.charEncoding != null ? this.charEncoding : response.getCharacterEncoding();
            if (this.charEncoding != null) {
                response.setCharacterEncoding(this.charEncoding);
            }
            switch (responseMimeType) {
                case JSON: {
                    response.setContentType("application/json");
                    break;
                }
                default: {
                    response.setContentType("text/xml");
                }
            }
            ServletOutputStream outputStream = response.getOutputStream();
            byte[] soapHeader = responseSoapParts[0];
            byte[] soapBody = responseSoapParts[1];
            Object[] byteChunks = null;
            try {
                switch (responseMimeType) {
                    case JSON: {
                        byteChunks = new Object[]{soapBody};
                        break;
                    }
                    default: {
                        String s0 = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n<" + "SOAP-ENV" + ":Envelope xmlns:" + "SOAP-ENV" + "=\"" + "http://schemas.xmlsoap.org/soap/envelope/" + "\" " + "SOAP-ENV" + ":encodingStyle=\"" + "http://schemas.xmlsoap.org/soap/encoding/" + "\" >" + "\n<" + "SOAP-ENV" + ":Header>\n";
                        String s2 = "</SOAP-ENV:Header>\n<SOAP-ENV:Body>\n";
                        String s4 = "\n</SOAP-ENV:Body>\n</SOAP-ENV:Envelope>\n";
                        byteChunks = new Object[]{s0.getBytes(encoding), soapHeader, s2.getBytes(encoding), soapBody, s4.getBytes(encoding)};
                        break;
                    }
                }
            }
            catch (UnsupportedEncodingException uee) {
                LOGGER.warn((Object)"This should be handled at begin of processing request", (Throwable)uee);
            }
            if (LOGGER.isDebugEnabled()) {
                buf = new StringBuilder(100);
                buf.append("XML/A response content").append(nl);
                try {
                    for (Object byteChunk : byteChunks) {
                        byte[] chunk = (byte[])byteChunk;
                        if (chunk == null || chunk.length <= 0) continue;
                        buf.append(new String(chunk, encoding));
                    }
                }
                catch (UnsupportedEncodingException uee) {
                    LOGGER.warn((Object)"This should be handled at begin of processing request", (Throwable)uee);
                }
                LOGGER.debug((Object)buf.toString());
            }
            if (LOGGER.isDebugEnabled()) {
                buf = new StringBuilder();
                buf.append("XML/A response content").append(nl);
            }
            try {
                int bufferSize = 4096;
                ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
                WritableByteChannel wch = Channels.newChannel((OutputStream)outputStream);
                for (Object byteChunk : byteChunks) {
                    int readSize;
                    if (byteChunk == null || ((byte[])byteChunk).length == 0) continue;
                    ReadableByteChannel rch = Channels.newChannel(new ByteArrayInputStream((byte[])byteChunk));
                    do {
                        buffer.clear();
                        readSize = rch.read(buffer);
                        buffer.flip();
                        int writeSize = 0;
                        while ((writeSize += wch.write(buffer)) < readSize) {
                        }
                    } while (readSize == bufferSize);
                    rch.close();
                }
                outputStream.flush();
            }
            catch (IOException ioe) {
                LOGGER.error((Object)"Damn exception when transferring bytes over sockets", (Throwable)ioe);
            }
        }
        catch (XmlaException xex) {
            throw xex;
        }
        catch (Exception ex) {
            throw new XmlaException("Server", "00MSMU01", "Unknown error marshalling soap message", ex);
        }
    }

    @Override
    protected void handleFault(HttpServletResponse response, byte[][] responseSoapParts, XmlaServlet.Phase phase, Throwable t) {
        String detail;
        String faultCode;
        String faultString;
        String code;
        response.reset();
        switch (phase) {
            case VALIDATE_HTTP_HEAD: {
                response.setStatus(401);
                break;
            }
            case INITIAL_PARSE: 
            case CALLBACK_PRE_ACTION: 
            case PROCESS_HEADER: 
            case PROCESS_BODY: 
            case CALLBACK_POST_ACTION: 
            case SEND_RESPONSE: {
                response.setStatus(200);
            }
        }
        if (t instanceof XmlaException) {
            XmlaException xex = (XmlaException)t;
            code = xex.getCode();
            faultString = xex.getFaultString();
            faultCode = XmlaException.formatFaultCode(xex);
            detail = XmlaException.formatDetail(xex.getDetail());
        } else {
            t = XmlaException.getRootCause(t);
            code = "00UE001";
            faultString = "Internal Error";
            faultCode = XmlaException.formatFaultCode("Server", code);
            detail = XmlaException.formatDetail(t.getMessage());
        }
        String encoding = response.getCharacterEncoding();
        ByteArrayOutputStream osBuf = new ByteArrayOutputStream();
        try {
            DefaultSaxWriter writer = new DefaultSaxWriter(osBuf, encoding);
            writer.startDocument();
            writer.startElement("SOAP-ENV:Fault");
            writer.startElement("faultcode");
            writer.characters(faultCode);
            writer.endElement();
            writer.startElement("faultstring");
            writer.characters(faultString);
            writer.endElement();
            writer.startElement("faultactor");
            writer.characters("Mondrian");
            writer.endElement();
            if (phase != XmlaServlet.Phase.PROCESS_HEADER) {
                writer.startElement("detail");
                writer.startElement("XA:error", "xmlns:XA", "http://mondrian.sourceforge.net");
                writer.startElement("code");
                writer.characters(code);
                writer.endElement();
                writer.startElement("desc");
                writer.characters(detail);
                writer.endElement();
                writer.endElement();
                writer.endElement();
            }
            writer.endElement();
            writer.endDocument();
        }
        catch (UnsupportedEncodingException uee) {
            LOGGER.warn((Object)"This should be handled at begin of processing request", (Throwable)uee);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unexcepted runimt exception when handing SOAP fault :(");
        }
        responseSoapParts[1] = osBuf.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionInfo getSessionInfo(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        SessionInfo sessionInfo = null;
        Map<String, SessionInfo> map = this.sessionInfos;
        synchronized (map) {
            sessionInfo = this.sessionInfos.get(sessionId);
        }
        if (sessionInfo == null) {
            LOGGER.error((Object)("No login credentials for found for session [" + sessionId + "]"));
        } else {
            LOGGER.debug((Object)("Found credentials for session id [" + sessionId + "], username=[" + sessionInfo.user + "] in servlet cache"));
        }
        return sessionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionInfo saveSessionInfo(String username, String password, String sessionId) {
        Map<String, SessionInfo> map = this.sessionInfos;
        synchronized (map) {
            SessionInfo sessionInfo = this.sessionInfos.get(sessionId);
            if (sessionInfo != null && Olap4jUtil.equal((Object)sessionInfo.user, (Object)username)) {
                if (password != null && password.length() > 0) {
                    sessionInfo = new SessionInfo(username, password);
                    this.sessionInfos.put(sessionId, sessionInfo);
                }
            } else {
                sessionInfo = new SessionInfo(username, password);
                this.sessionInfos.put(sessionId, sessionInfo);
            }
            return sessionInfo;
        }
    }

    private static class SessionInfo {
        final String user;
        final String password;

        public SessionInfo(String user, String password) {
            this.user = user;
            this.password = password;
        }
    }
}

