/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.parser;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlrpc.parser.TypeParser;
import org.apache.xmlrpc.parser.TypeParserImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class ExtParser
implements TypeParser {
    private Locator locator;
    private ContentHandler handler;
    private int level = 0;
    private final List prefixes = new ArrayList();

    protected abstract ContentHandler getExtHandler() throws SAXException;

    protected abstract String getTagName();

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void characters(char[] pChars, int pOffset, int pLength) throws SAXException {
        if (this.handler == null) {
            if (!TypeParserImpl.isEmpty(pChars, pOffset, pLength)) {
                throw new SAXParseException("Unexpected non-whitespace content: " + new String(pChars, pOffset, pLength), this.locator);
            }
        } else {
            this.handler.characters(pChars, pOffset, pLength);
        }
    }

    @Override
    public void ignorableWhitespace(char[] pChars, int pOffset, int pLength) throws SAXException {
        if (this.handler != null) {
            this.ignorableWhitespace(pChars, pOffset, pLength);
        }
    }

    @Override
    public void endPrefixMapping(String pPrefix) throws SAXException {
        if (this.handler != null) {
            this.handler.endPrefixMapping(pPrefix);
        }
    }

    @Override
    public void skippedEntity(String pName) throws SAXException {
        if (this.handler == null) {
            throw new SAXParseException("Don't know how to handle entity " + pName, this.locator);
        }
        this.handler.skippedEntity(pName);
    }

    @Override
    public void setDocumentLocator(Locator pLocator) {
        this.locator = pLocator;
        if (this.handler != null) {
            this.handler.setDocumentLocator(pLocator);
        }
    }

    @Override
    public void processingInstruction(String pTarget, String pData) throws SAXException {
        if (this.handler != null) {
            this.handler.processingInstruction(pTarget, pData);
        }
    }

    @Override
    public void startPrefixMapping(String pPrefix, String pURI) throws SAXException {
        if (this.handler == null) {
            this.prefixes.add(pPrefix);
            this.prefixes.add(pURI);
        } else {
            this.handler.startPrefixMapping(pPrefix, pURI);
        }
    }

    @Override
    public void startElement(String pURI, String pLocalName, String pQName, Attributes pAttrs) throws SAXException {
        switch (this.level++) {
            case 0: {
                String tag = this.getTagName();
                if (!"http://ws.apache.org/xmlrpc/namespaces/extensions".equals(pURI) || !tag.equals(pLocalName)) {
                    throw new SAXParseException("Expected " + new QName("http://ws.apache.org/xmlrpc/namespaces/extensions", tag) + ", got " + new QName(pURI, pLocalName), this.locator);
                }
                this.handler = this.getExtHandler();
                this.handler.startDocument();
                for (int i = 0; i < this.prefixes.size(); i += 2) {
                    this.handler.startPrefixMapping((String)this.prefixes.get(i), (String)this.prefixes.get(i + 1));
                }
                break;
            }
            default: {
                this.handler.startElement(pURI, pLocalName, pQName, pAttrs);
            }
        }
    }

    @Override
    public void endElement(String pURI, String pLocalName, String pQName) throws SAXException {
        switch (--this.level) {
            case 0: {
                for (int i = 0; i < this.prefixes.size(); i += 2) {
                    this.handler.endPrefixMapping((String)this.prefixes.get(i));
                }
                this.handler.endDocument();
                this.handler = null;
                break;
            }
            default: {
                this.handler.endElement(pURI, pLocalName, pQName);
            }
        }
    }
}

