/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.utils.arquillian;

import java.io.Serializable;
import java.time.Duration;
import java.util.function.Function;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfiguration;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

public final class ArquillianPrimeFaces {
    private ArquillianPrimeFaces() {
        throw new AssertionError((Object)"This is a utility class.");
    }

    public static void configureTimeouts(WebDriver browser, final Duration timeout) {
        while (browser instanceof GrapheneProxyInstance) {
            browser = (WebDriver)((GrapheneProxyInstance)browser).unwrap();
        }
        GrapheneContext.setContextFor((GrapheneConfiguration)new GrapheneConfiguration(){

            public long getWaitAjaxInterval() {
                return timeout.getSeconds();
            }

            public long getWaitGuardInterval() {
                return timeout.getSeconds();
            }

            public long getWaitGuiInterval() {
                return timeout.getSeconds();
            }

            public long getWaitModelInterval() {
                return timeout.getSeconds();
            }
        }, (WebDriver)browser, Default.class);
    }

    public static void assertPresent(WebElement element) {
        try {
            Assert.assertTrue((boolean)element.isDisplayed());
        }
        catch (NoSuchElementException e) {
            Assert.fail((String)e.toString());
        }
    }

    public static void assertAbsent(WebElement element) {
        try {
            Assert.assertFalse((boolean)element.isDisplayed());
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public static WebElement getForm(WebElement element) {
        if (element.getTagName().equals("form")) {
            return element;
        }
        return ArquillianPrimeFaces.getForm(ArquillianPrimeFaces.getNamingContainer(element));
    }

    private static WebElement getNamingContainer(WebElement element) {
        String clientId = element.getAttribute("id");
        WebElement document = element.findElement(By.xpath((String)"/*"));
        return document.findElement(By.id((String)clientId.substring(0, clientId.lastIndexOf(58))));
    }

    public static String getViewState(WebElement element) {
        return ArquillianPrimeFaces.getForm(element).findElement(By.name((String)"javax.faces.ViewState")).getAttribute("value");
    }

    public static void assertStateless(WebElement element) {
        Assert.assertEquals((Object)"stateless", (Object)ArquillianPrimeFaces.getViewState(element));
    }

    public static void assertStateful(WebElement element) {
        Assert.assertNotEquals((Object)"stateless", (Object)ArquillianPrimeFaces.getViewState(element));
    }

    public static boolean isValid(WebElement element) {
        if (element.getAttribute("class").contains("ui-state-error")) {
            return false;
        }
        if (element.getAttribute("class").contains("ui-state-default")) {
            return true;
        }
        return ArquillianPrimeFaces.isValid(element.findElement(By.cssSelector((String)".ui-state-default")));
    }

    public static void assertValid(WebElement element) {
        Assert.assertTrue((String)("Must be valid: " + element), (boolean)ArquillianPrimeFaces.isValid(element));
    }

    public static void assertInvalid(WebElement element) {
        Assert.assertFalse((String)("Must be invalid: " + element), (boolean)ArquillianPrimeFaces.isValid(element));
    }

    public static String setSelectOneMenuValue(WebElement selectOneMenu, Serializable value) {
        String clientId = selectOneMenu.getAttribute("id");
        WebElement document = selectOneMenu.findElement(By.xpath((String)"/*"));
        WebElement input = document.findElement(By.id((String)(clientId + "_input")));
        String itemValue = value.toString();
        String itemLabel = (String)ArquillianPrimeFaces.executeScript("return $(document.getElementById('" + input.getAttribute("id") + "')).find('option[value=\"" + itemValue + "\"]').text()");
        document.findElement(By.id((String)(clientId + "_label"))).click();
        WebElement panel = document.findElement(By.id((String)(clientId + "_panel")));
        WebElement selectItem = panel.findElement(By.cssSelector((String)(".ui-selectonemenu-item[data-label='" + itemLabel + "']")));
        if (input.getAttribute("onchange") != null) {
            ((WebElement)Graphene.guardAjax((Object)selectItem)).click();
        } else {
            selectItem.click();
        }
        return itemLabel;
    }

    public static String setSelectOneRadioValue(WebElement selectOneRadio, Serializable value) {
        String itemValue = value.toString();
        WebElement input = selectOneRadio.findElement(By.cssSelector((String)("input[value='" + itemValue + "']")));
        String itemLabel = selectOneRadio.findElement(By.cssSelector((String)("label[for='" + input.getAttribute("id") + "']"))).getText();
        WebElement findElement = input.findElement(By.xpath((String)"ancestor::div[contains(@class,'ui-radiobutton')]"));
        WebElement selectItem = findElement.findElement(By.cssSelector((String)".ui-radiobutton-box"));
        if (!selectItem.getAttribute("class").contains("ui-state-active")) {
            if (input.getAttribute("onchange") != null) {
                ((WebElement)Graphene.guardAjax((Object)selectItem)).click();
            } else {
                selectItem.click();
            }
        }
        return itemLabel;
    }

    public static String setSelectOneButtonValue(WebElement selectOneButton, Serializable value) {
        String itemValue = value.toString();
        WebElement input = selectOneButton.findElement(By.cssSelector((String)("input[value='" + itemValue + "']")));
        WebElement selectItem = input.findElement(By.xpath((String)"ancestor::div[contains(@class,'ui-state-default')]"));
        String itemLabel = selectItem.findElement(By.cssSelector((String)".ui-button-text")).getText();
        if (!selectItem.getAttribute("class").contains("ui-state-active")) {
            selectItem.click();
        }
        return itemLabel;
    }

    public static void setInputTextValue(WebElement inputText, Serializable value) {
        inputText.clear();
        inputText.sendKeys(new CharSequence[]{value.toString()});
    }

    public static void setInputMaskValue(WebElement inputMask, Serializable value) {
        String clientId = inputMask.getAttribute("id");
        ArquillianPrimeFaces.executeScript("document.getElementById('" + clientId + "').value='" + value + "'");
    }

    public static void setInputNumberValue(WebElement inputNumber, Number value) {
        String clientId = inputNumber.getAttribute("id");
        WebElement input = inputNumber.findElement(By.id((String)(clientId + "_input")));
        ArquillianPrimeFaces.setInputTextValue(input, (Serializable)((Object)String.valueOf(value)));
    }

    public static void setSpinnerValue(WebElement spinner, Number value) {
        ArquillianPrimeFaces.setInputNumberValue(spinner, value);
    }

    public static void setSliderValue(WebElement slider, Number value) {
        ArquillianPrimeFaces.setInputTextValue(slider, value);
    }

    public static void setAutoCompleteQuery(WebElement autoComplete, String query) {
        ArquillianPrimeFaces.setAutoCompleteQuery(autoComplete, query, true);
    }

    public static void setAutoCompleteQuery(WebElement autoComplete, String query, boolean resultsExpected) {
        String clientId = autoComplete.getAttribute("id");
        WebElement input = autoComplete.findElement(By.id((String)(clientId + "_input")));
        ArquillianPrimeFaces.setInputTextValue(input, (Serializable)((Object)query));
        if (resultsExpected) {
            WebElement document = autoComplete.findElement(By.xpath((String)"/*"));
            WebElement panel = document.findElement(By.id((String)(clientId + "_panel")));
            Graphene.waitGui().until((Function)ExpectedConditions.or((ExpectedCondition[])new ExpectedCondition[]{ExpectedConditions.visibilityOf((WebElement)panel), ExpectedConditions.attributeContains((WebElement)input, (String)"class", (String)"ui-state-error")}));
        }
    }

    public static String setAutoCompleteValue(WebElement autoComplete, Serializable value) {
        String clientId = autoComplete.getAttribute("id");
        WebElement document = autoComplete.findElement(By.xpath((String)"/*"));
        WebElement panel = document.findElement(By.id((String)(clientId + "_panel")));
        Graphene.waitGui().until((Function)ExpectedConditions.visibilityOf((WebElement)panel));
        WebElement selectItem = panel.findElement(By.cssSelector((String)("[data-item-value='" + value + "']")));
        String itemLabel = selectItem.getAttribute("data-item-label");
        selectItem.click();
        return itemLabel;
    }

    public static String setAutoCompleteValue(WebElement autoComplete, String query, Serializable value) {
        ArquillianPrimeFaces.setAutoCompleteQuery(autoComplete, query);
        return ArquillianPrimeFaces.setAutoCompleteValue(autoComplete, value);
    }

    public static void setSelectBooleanCheckboxChecked(WebElement selectBooleanCheckbox, boolean checked) {
        WebElement box = selectBooleanCheckbox.findElement(By.cssSelector((String)".ui-chkbox-box"));
        if (box.getAttribute("class").contains("ui-state-active")) {
            if (!checked) {
                box.click();
            }
        } else if (checked) {
            box.click();
        }
    }

    public static void clickCommandLink(WebElement commandLink) {
        ArquillianPrimeFaces.clickCommandElement(commandLink, false);
    }

    public static void clickCommandLinkWithRedirect(WebElement commandLink) {
        ArquillianPrimeFaces.clickCommandElement(commandLink, true);
    }

    public static void clickCommandButton(WebElement commandButton) {
        ArquillianPrimeFaces.clickCommandElement(commandButton, false);
    }

    public static void clickCommandButtonWithRedirect(WebElement commandButton) {
        ArquillianPrimeFaces.clickCommandElement(commandButton, true);
    }

    private static void clickCommandElement(WebElement command, boolean redirectExpected) {
        Graphene.waitGui().until((Function)ExpectedConditions.elementToBeClickable((WebElement)command));
        if (redirectExpected) {
            ((WebElement)Graphene.waitForHttp((Object)command)).click();
        } else if (command.getAttribute("onclick") != null && command.getAttribute("onclick").contains("PrimeFaces.ab")) {
            ((WebElement)Graphene.guardAjax((Object)command)).click();
        } else {
            ((WebElement)Graphene.guardHttp((Object)command)).click();
        }
    }

    public static void clickLink(WebElement link) {
        Graphene.waitGui().until((Function)ExpectedConditions.elementToBeClickable((WebElement)link));
        if ("_blank".equals(link.getAttribute("target"))) {
            link.click();
        } else {
            ((WebElement)Graphene.guardHttp((Object)link)).click();
        }
    }

    public static void clickButton(WebElement button) {
        Graphene.waitGui().until((Function)ExpectedConditions.elementToBeClickable((WebElement)button));
        String onclick = button.getAttribute("onclick");
        if (!onclick.startsWith("window.open") || onclick.endsWith("'_blank')")) {
            button.click();
        } else {
            ((WebElement)Graphene.guardHttp((Object)button)).click();
        }
    }

    private static <T> T executeScript(String script) {
        JavascriptExecutor browser = (JavascriptExecutor)GrapheneContext.getContextFor(Default.class).getWebDriver(new Class[0]);
        return (T)browser.executeScript(script, new Object[0]);
    }
}

