/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.utils.arquillian;

import java.time.LocalDate;
import java.time.Month;
import java.time.YearMonth;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class Entropy {
    private static final List<String> LETTERS_AND_DIGITS = IntStream.range(0, 127).filter(Character::isLetterOrDigit).mapToObj(i -> String.valueOf((char)i)).collect(Collectors.toList());

    private Entropy() {
        throw new AssertionError((Object)"This is a utility class.");
    }

    public static String getRandomString() {
        return UUID.randomUUID().toString();
    }

    public static String getRandomStringOfFixedLength(int length) {
        return IntStream.range(0, length).mapToObj(i -> Entropy.getRandomListItem(LETTERS_AND_DIGITS)).collect(Collectors.joining());
    }

    public static int getRandomNumberBetween(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    public static long getRandomNumberOfFixedLength(int length) {
        String zeroes = String.join((CharSequence)"", Collections.nCopies(length - 1, "0"));
        return Long.parseLong("1" + zeroes) + ThreadLocalRandom.current().nextLong(Long.parseLong("9" + zeroes));
    }

    public static <E> E getRandomListItem(List<E> list) {
        return list.get(ThreadLocalRandom.current().nextInt(0, list.size()));
    }

    public static <E extends Enum<E>> E getRandomEnumValue(Class<E> enumType) {
        Enum[] values = (Enum[])enumType.getEnumConstants();
        return (E)values[ThreadLocalRandom.current().nextInt(0, values.length)];
    }

    public static LocalDate getRandomLocalDateBetweenYears(int minYear, int maxYear) {
        LocalDate minDate = LocalDate.of(minYear, Month.JANUARY, 1);
        LocalDate maxDate = LocalDate.of(maxYear, Month.DECEMBER, Month.DECEMBER.maxLength());
        return LocalDate.ofEpochDay(ThreadLocalRandom.current().nextLong(minDate.toEpochDay(), maxDate.toEpochDay()));
    }

    public static LocalDate getRandomDateOfBirthBetweenAges(int minAge, int maxAge) {
        LocalDate now = LocalDate.now();
        int year = Entropy.getRandomNumberBetween(now.minusYears(maxAge - 1).getYear(), now.minusYears(minAge + 1).getYear());
        Month month = Entropy.getRandomEnumValue(Month.class);
        int day = Entropy.getRandomNumberBetween(1, YearMonth.of(year, month).lengthOfMonth());
        return LocalDate.of(year, month, day);
    }
}

