/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.collections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.collections.tuple.Pair;
import org.onebusaway.collections.tuple.Tuples;

public class DirectedGraph<T> {
    private Map<T, Set<T>> _outboundEdges = new HashMap<T, Set<T>>();
    private Map<T, Set<T>> _inboundEdges = new HashMap<T, Set<T>>();

    public DirectedGraph() {
    }

    public DirectedGraph(DirectedGraph<T> graph) {
        for (T t : graph.getNodes()) {
            this.addNode(t);
        }
        for (Pair pair : graph.getEdges()) {
            this.addEdge(pair.getFirst(), pair.getSecond());
        }
    }

    public Set<T> getNodes() {
        HashSet<T> nodes = new HashSet<T>();
        nodes.addAll(this._outboundEdges.keySet());
        nodes.addAll(this._inboundEdges.keySet());
        return nodes;
    }

    public Set<Pair<T>> getEdges() {
        HashSet<Pair<T>> edges = new HashSet<Pair<T>>();
        for (T from : this._outboundEdges.keySet()) {
            for (T to : this._outboundEdges.get(from)) {
                edges.add(Tuples.pair(from, to));
            }
        }
        return edges;
    }

    public Set<T> getInboundNodes(T node) {
        return this.get(this._inboundEdges, node, false);
    }

    public Set<T> getOutboundNodes(T node) {
        return this.get(this._outboundEdges, node, false);
    }

    public boolean isConnected(T from, T to) {
        if (from.equals(to)) {
            return true;
        }
        return this.isConnected(from, to, new HashSet());
    }

    public void addNode(T node) {
        this.get(this._outboundEdges, node, true);
        this.get(this._inboundEdges, node, true);
    }

    public void addEdge(T from, T to) {
        this.get(this._outboundEdges, from, true).add(to);
        this.get(this._inboundEdges, to, true).add(from);
    }

    public void removeEdge(T from, T to) {
        this.get(this._outboundEdges, from, false).remove(to);
        this.get(this._inboundEdges, to, false).remove(from);
    }

    private void removeNode(T node) {
        for (T from : this.get(this._inboundEdges, node, false)) {
            this.get(this._outboundEdges, from, false).remove(node);
        }
        this._inboundEdges.remove(node);
        for (T to : this.get(this._outboundEdges, node, false)) {
            this.get(this._inboundEdges, to, false).remove(node);
        }
        this._outboundEdges.remove(node);
    }

    public List<T> getTopologicalSort(Comparator<T> tieBreaker) {
        ArrayList order = new ArrayList();
        DirectedGraph<Object> g = new DirectedGraph<Object>(this);
        Set<T> nodes;
        while (!(nodes = g.getNodes()).isEmpty()) {
            ArrayList<T> noInbound = new ArrayList<T>();
            for (T node : nodes) {
                if (!g.getInboundNodes(node).isEmpty()) continue;
                noInbound.add(node);
            }
            if (noInbound.isEmpty()) {
                throw new IllegalStateException("cycle");
            }
            if (tieBreaker != null) {
                Collections.sort(noInbound, tieBreaker);
            }
            Object node = noInbound.getFirst();
            order.add(node);
            g.removeNode(node);
        }
        return order;
    }

    private boolean isConnected(T from, T to, Set<T> visited) {
        if (from.equals(to)) {
            return true;
        }
        for (T next : this.get(this._outboundEdges, from, false)) {
            if (!visited.add(next) || !this.isConnected(next, to, visited)) continue;
            return true;
        }
        return false;
    }

    private Set<T> get(Map<T, Set<T>> edges, T key, boolean create) {
        Set<T> set = edges.get(key);
        if (set == null) {
            set = new HashSet<T>();
            if (create) {
                edges.put(key, set);
            }
        }
        return set;
    }
}

