/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.collections.beans;

import org.onebusaway.collections.beans.DefaultPropertyMethodResolver;
import org.onebusaway.collections.beans.PropertyInvocationResult;
import org.onebusaway.collections.beans.PropertyMethod;
import org.onebusaway.collections.beans.PropertyMethodResolver;

public final class PropertyPathExpression {
    private String[] _properties;
    private transient PropertyMethod[] _methods = null;
    private PropertyMethodResolver _resolver = new DefaultPropertyMethodResolver();

    public static Object evaluate(Object target, String query) {
        return new PropertyPathExpression(query).invoke(target);
    }

    public PropertyPathExpression(String query) {
        this._properties = query.split("\\.");
    }

    public void setPropertyMethodResolver(PropertyMethodResolver resolver) {
        this._resolver = resolver;
    }

    public String getPath() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this._properties.length; ++i) {
            if (i > 0) {
                b.append('.');
            }
            b.append(this._properties[i]);
        }
        return b.toString();
    }

    public Class<?> initialize(Class<?> sourceValueType) {
        if (this._methods != null) {
            if (this._methods.length == 0) {
                return sourceValueType;
            }
            return this._methods[this._methods.length - 1].getReturnType();
        }
        this._methods = new PropertyMethod[this._properties.length];
        for (int i = 0; i < this._properties.length; ++i) {
            this._methods[i] = this._resolver.getPropertyMethod(sourceValueType, this._properties[i]);
            sourceValueType = this._methods[i].getReturnType();
        }
        return sourceValueType;
    }

    public Class<?> getParentType(Class<?> sourceValueType) {
        this.initialize(sourceValueType);
        if (this._methods.length < 2) {
            return sourceValueType;
        }
        return this._methods[this._methods.length - 2].getReturnType();
    }

    public String getLastProperty() {
        return this._properties[this._properties.length - 1];
    }

    public Object invoke(Object value) {
        return this.invokeReturningFullResult((Object)value).value;
    }

    public PropertyInvocationResult invokeReturningFullResult(Object value) {
        if (this._methods == null) {
            this.initialize(value.getClass());
        }
        Object parent = null;
        String propertyName = null;
        for (int i = 0; i < this._properties.length; ++i) {
            parent = value;
            propertyName = this._properties[i];
            PropertyMethod m = this._methods[i];
            try {
                value = m.invoke(value);
                continue;
            }
            catch (Exception ex) {
                throw new IllegalStateException("error invoking property reader: obj=" + String.valueOf(value) + " property=" + this._properties[i], ex);
            }
        }
        return new PropertyInvocationResult(parent, propertyName, value);
    }
}

