/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.collections.adapter;

import java.util.Map;
import org.onebusaway.collections.adapter.AdapterLibrary;
import org.onebusaway.collections.adapter.IAdapter;

class MapEntryValueAdapter<KEY, FROM_VALUE, TO_VALUE>
implements IAdapter<Map.Entry<KEY, FROM_VALUE>, Map.Entry<KEY, TO_VALUE>> {
    private IAdapter<FROM_VALUE, TO_VALUE> _adapter;

    public MapEntryValueAdapter(IAdapter<FROM_VALUE, TO_VALUE> adapter) {
        this._adapter = adapter;
    }

    @Override
    public Map.Entry<KEY, TO_VALUE> adapt(Map.Entry<KEY, FROM_VALUE> source) {
        TO_VALUE v = AdapterLibrary.apply(this._adapter, source.getValue());
        return new EntryImpl<KEY, TO_VALUE>(source.getKey(), v);
    }

    private static class EntryImpl<K, V>
    implements Map.Entry<K, V> {
        private final K _key;
        private final V _value;

        public EntryImpl(K key, V value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public K getKey() {
            return this._key;
        }

        @Override
        public V getValue() {
            return this._value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

