/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.collections.combinations;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.onebusaway.collections.tuple.Pair;
import org.onebusaway.collections.tuple.Tuples;

public class SequentialPairIterator<T>
implements Iterator<Pair<T>> {
    private T _prev = null;
    private T _current = null;
    private Iterator<T> _iterator;

    public SequentialPairIterator(Iterable<T> elements) {
        this._iterator = elements.iterator();
        if (this._iterator.hasNext()) {
            this._current = this._iterator.next();
        }
        this.getNext();
    }

    @Override
    public boolean hasNext() {
        return this._current != null;
    }

    @Override
    public Pair<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Pair<T> pair = Tuples.pair(this._prev, this._current);
        this.getNext();
        return pair;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void getNext() {
        this._prev = this._current;
        this._current = this._iterator.hasNext() ? this._iterator.next() : null;
    }
}

