/**
 * Copyright (C) 2011 Brian Ferris <bdferris@onebusaway.org>
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 *
 * <p>http://www.apache.org/licenses/LICENSE-2.0
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.onebusaway.csv_entities.exceptions;

import java.io.Serial;

/**
 * Indicates an error was thrown when reading / writing CSV. This exception provides information
 * about line number and path information about where the error occurred.
 *
 * @author bdferris
 */
public class CsvEntityIOException extends CsvEntityException {

  @Serial private static final long serialVersionUID = 1L;

  private String _path;

  private int _lineNumber;

  public CsvEntityIOException(Class<?> entityType, String path, int lineNumber, Throwable cause) {
    super(
        entityType,
        "io error: entityType="
            + entityType.getName()
            + " path="
            + path
            + " lineNumber="
            + lineNumber,
        cause);
    _path = path;
    _lineNumber = lineNumber;
  }

  public String getPath() {
    return _path;
  }

  public int getLineNumber() {
    return _lineNumber;
  }
}
