/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities.schema;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.onebusaway.csv_entities.HasExtensions;
import org.onebusaway.csv_entities.exceptions.EntityInstantiationException;
import org.onebusaway.csv_entities.schema.AbstractFieldMapping;
import org.onebusaway.csv_entities.schema.BaseEntitySchema;
import org.onebusaway.csv_entities.schema.DefaultFieldMapping;
import org.onebusaway.csv_entities.schema.EntitySchema;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.EntityValidator;
import org.onebusaway.csv_entities.schema.ExtensionEntitySchema;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.csv_entities.schema.FieldMappingFactory;
import org.onebusaway.csv_entities.schema.ListableCsvMappingFactory;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.csv_entities.schema.annotations.CsvFieldNameConvention;
import org.onebusaway.csv_entities.schema.annotations.CsvFields;
import org.onebusaway.csv_entities.schema.beans.CsvEntityMappingBean;
import org.onebusaway.csv_entities.schema.beans.CsvFieldMappingBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntitySchemaFactoryImpl
implements EntitySchemaFactory,
ListableCsvMappingFactory {
    private static final Logger _log = LoggerFactory.getLogger(AbstractEntitySchemaFactoryImpl.class);
    private boolean _initialized = false;
    private Map<Class<?>, CsvEntityMappingBean> _mappingBeansByClass = new HashMap();
    private Map<Class<?>, List<Class<?>>> _extensionsByClass = new HashMap();
    private Map<Class<?>, EntitySchema> _schemasByClass = new HashMap();

    public void addExtension(Class<? extends HasExtensions> type, Class<?> extensionType) {
        List<Class<?>> extensionTypes = this._extensionsByClass.get(type);
        if (extensionTypes == null) {
            extensionTypes = new ArrayList();
            this._extensionsByClass.put(type, extensionTypes);
        }
        extensionTypes.add(extensionType);
        this._schemasByClass.remove(type);
    }

    @Override
    public Collection<CsvEntityMappingBean> getEntityMappings() {
        this.initialize();
        return new ArrayList<CsvEntityMappingBean>(this._mappingBeansByClass.values());
    }

    @Override
    public EntitySchema getSchema(Class<?> entityClass) {
        this.initialize();
        EntitySchema schema = this._schemasByClass.get(entityClass);
        if (schema == null) {
            schema = this.createSchemaForEntityClass(entityClass);
            this._schemasByClass.put(entityClass, schema);
        }
        return schema;
    }

    protected abstract void processBeanDefinitions();

    protected void registerBeanDefinition(CsvEntityMappingBean bean) {
        CsvEntityMappingBean existingBean = this._mappingBeansByClass.get(bean.getType());
        if (existingBean != null) {
            CsvEntityMappingBean merged = new CsvEntityMappingBean(bean.getType());
            this.mergeBeans(existingBean, merged);
            this.mergeBeans(bean, merged);
            bean = merged;
        }
        this._mappingBeansByClass.put(bean.getType(), bean);
    }

    protected void applyCsvFieldsAnnotationToBean(Class<?> entityClass, CsvEntityMappingBean entityBean) {
        CsvFields csvFields = entityClass.getAnnotation(CsvFields.class);
        if (csvFields != null) {
            String[] fieldsInOrder;
            entityBean.setFilename(csvFields.filename());
            if (!csvFields.prefix().equals("")) {
                entityBean.setPrefix(csvFields.prefix());
            }
            if (csvFields.required()) {
                entityBean.setRequired(csvFields.required());
            }
            if ((fieldsInOrder = csvFields.fieldOrder()).length != 0) {
                for (String fieldInOrder : fieldsInOrder) {
                    entityBean.addFieldInOrder(fieldInOrder);
                }
            }
            if (csvFields.fieldNameConvention() != CsvFieldNameConvention.UNSPECIFIED) {
                entityBean.setFieldNameConvention(csvFields.fieldNameConvention());
            }
        }
    }

    protected void applyCsvFieldAnnotationToBean(Field field, CsvFieldMappingBean fieldBean) {
        CsvField csvField = field.getAnnotation(CsvField.class);
        if (csvField != null) {
            Class<? extends FieldMappingFactory> mapping;
            if (!csvField.name().equals("")) {
                fieldBean.setName(csvField.name());
            }
            if (csvField.ignore()) {
                fieldBean.setIgnore(csvField.ignore());
            }
            if (csvField.optional()) {
                fieldBean.setOptional(csvField.optional());
            }
            if (csvField.alwaysIncludeInOutput()) {
                fieldBean.setAlwaysIncludeInOutput(csvField.alwaysIncludeInOutput());
            }
            if (csvField.order() != Integer.MAX_VALUE) {
                fieldBean.setOrder(csvField.order());
            }
            if (!csvField.defaultValue().isEmpty()) {
                fieldBean.setDefaultValue(csvField.defaultValue());
            }
            if (!(mapping = csvField.mapping()).equals(FieldMappingFactory.class)) {
                try {
                    FieldMappingFactory factory = mapping.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    fieldBean.setMapping(factory);
                }
                catch (Exception ex) {
                    throw new EntityInstantiationException(mapping, (Throwable)ex);
                }
            }
        }
    }

    private void initialize() {
        if (!this._initialized) {
            this.processBeanDefinitions();
            this._initialized = true;
        }
    }

    private void mergeBeans(CsvEntityMappingBean source, CsvEntityMappingBean target) {
        List<String> fieldsInOrder;
        if (source.isFilenameSet()) {
            target.setFilename(source.getFilename());
        }
        if (source.isPrefixSet()) {
            target.setPrefix(source.getPrefix());
        }
        if (source.isRequiredSet()) {
            target.setRequired(source.isRequired());
        }
        if (source.isAutoGenerateSchemaSet()) {
            target.setAutoGenerateSchema(source.isAutoGenerateSchema());
        }
        if (!(fieldsInOrder = source.getFieldsInOrder()).isEmpty()) {
            target.setFieldsInOrder(fieldsInOrder);
        }
        for (FieldMapping mapping : source.getAdditionalFieldMappings()) {
            target.addAdditionalFieldMapping(mapping);
        }
        Map<Field, CsvFieldMappingBean> sourceFields = source.getFields();
        Map<Field, CsvFieldMappingBean> targetFields = target.getFields();
        for (Map.Entry<Field, CsvFieldMappingBean> entry : sourceFields.entrySet()) {
            Field sourceField = entry.getKey();
            CsvFieldMappingBean sourceFieldBean = entry.getValue();
            CsvFieldMappingBean targetFieldBean = targetFields.get(sourceField);
            if (targetFieldBean == null) {
                targetFieldBean = sourceFieldBean;
            } else {
                this.mergeFields(sourceFieldBean, targetFieldBean);
            }
            targetFields.put(sourceField, targetFieldBean);
        }
    }

    private void mergeFields(CsvFieldMappingBean source, CsvFieldMappingBean target) {
        if (source.isNameSet()) {
            target.setName(source.getName());
        }
        if (source.isIgnoreSet()) {
            target.setIgnore(target.isIgnore());
        }
        if (source.isMappingSet()) {
            target.setMapping(source.getMapping());
        }
        if (source.isOptionalSet()) {
            target.setOptional(source.isOptional());
        }
        if (source.isAlwaysIncludeInOutput()) {
            target.setAlwaysIncludeInOutput(source.isAlwaysIncludeInOutput());
        }
        if (source.isOrderSet()) {
            target.setOrder(source.getOrder());
        }
        if (source.getDefaultValue() != null) {
            target.setDefaultValue(source.getDefaultValue());
        }
    }

    private EntitySchema createSchemaForEntityClass(Class<?> entityClass) {
        List<Class<?>> extensionTypes;
        CsvEntityMappingBean mappingBean = this.getMappingBeanForEntityType(entityClass);
        String name = this.getEntityClassAsEntityName(entityClass);
        if (mappingBean.isFilenameSet()) {
            name = mappingBean.getFilename();
        }
        boolean required = false;
        if (mappingBean.isRequiredSet()) {
            required = mappingBean.isRequired();
        }
        EntitySchema schema = new EntitySchema(entityClass, name, required);
        this.fillSchemaForEntityClass(entityClass, mappingBean, schema);
        List<String> fieldsInOrder = mappingBean.getFieldsInOrder();
        if (!fieldsInOrder.isEmpty()) {
            schema.setFieldsInOrder(fieldsInOrder);
        }
        if ((extensionTypes = this._extensionsByClass.get(entityClass)) != null) {
            for (Class<?> extensionType : extensionTypes) {
                CsvEntityMappingBean extensionMappingBean = this.getMappingBeanForEntityType(extensionType);
                ExtensionEntitySchema extensionSchema = new ExtensionEntitySchema(extensionType);
                this.fillSchemaForEntityClass(extensionType, extensionMappingBean, extensionSchema);
                schema.addExtension(extensionSchema);
            }
        }
        return schema;
    }

    private CsvEntityMappingBean getMappingBeanForEntityType(Class<?> entityClass) {
        CsvEntityMappingBean mappingBean = this._mappingBeansByClass.get(entityClass);
        if (mappingBean == null) {
            mappingBean = new CsvEntityMappingBean(entityClass);
            this.applyCsvFieldsAnnotationToBean(entityClass, mappingBean);
        }
        return mappingBean;
    }

    private void fillSchemaForEntityClass(Class<?> entityClass, CsvEntityMappingBean mappingBean, BaseEntitySchema schema) {
        Map<Field, CsvFieldMappingBean> existingFieldBeans = mappingBean.getFields();
        ArrayList<FieldMapping> fieldMappings = new ArrayList<FieldMapping>();
        String prefix = "";
        if (mappingBean.isPrefixSet()) {
            prefix = mappingBean.getPrefix();
        }
        CsvFieldNameConvention fieldNameConvention = CsvFieldNameConvention.UNSPECIFIED;
        if (mappingBean.getFieldNameConvention() != null) {
            fieldNameConvention = mappingBean.getFieldNameConvention();
        }
        if (fieldNameConvention == CsvFieldNameConvention.UNSPECIFIED) {
            fieldNameConvention = CsvFieldNameConvention.UNDERSCORE;
        }
        boolean autoGenerateSchema = true;
        if (mappingBean.isAutoGenerateSchemaSet()) {
            autoGenerateSchema = mappingBean.isAutoGenerateSchema();
        }
        if (autoGenerateSchema) {
            LinkedHashSet remainingFields = new LinkedHashSet();
            for (Field field : entityClass.getDeclaredFields()) {
                remainingFields.add(field);
            }
            for (Map.Entry entry : existingFieldBeans.entrySet()) {
                Field field = (Field)entry.getKey();
                if (!remainingFields.remove(field)) {
                    _log.warn("field found in mapping but not in class: " + String.valueOf(field));
                    continue;
                }
                this.addFieldMapping(entityClass, prefix, fieldNameConvention, field, (CsvFieldMappingBean)entry.getValue(), fieldMappings);
            }
            Iterator iterator = remainingFields.iterator();
            while (iterator.hasNext()) {
                boolean ignore;
                Field field = (Field)iterator.next();
                CsvFieldMappingBean fieldMappingBean = new CsvFieldMappingBean(field);
                this.applyCsvFieldAnnotationToBean(field, fieldMappingBean);
                boolean bl = ignore = (field.getModifiers() & 0x18) != 0;
                if (ignore) {
                    fieldMappingBean.setIgnore(ignore);
                }
                this.addFieldMapping(entityClass, prefix, fieldNameConvention, field, fieldMappingBean, fieldMappings);
            }
        }
        for (FieldMapping fieldMapping : mappingBean.getAdditionalFieldMappings()) {
            fieldMappings.add(fieldMapping);
        }
        ArrayList<FieldMapping> sortableMappings = new ArrayList<FieldMapping>();
        ArrayList<FieldMapping> unsortableMappings = new ArrayList<FieldMapping>();
        for (FieldMapping fieldMapping : fieldMappings) {
            if (fieldMapping.getOrder() == Integer.MAX_VALUE) {
                unsortableMappings.add(fieldMapping);
                continue;
            }
            sortableMappings.add(fieldMapping);
        }
        if (!sortableMappings.isEmpty()) {
            Collections.sort(sortableMappings, new FieldMappingComparator());
            fieldMappings.clear();
            fieldMappings.addAll(sortableMappings);
            fieldMappings.addAll(unsortableMappings);
        }
        for (FieldMapping mapping : fieldMappings) {
            schema.addField(mapping);
        }
        ArrayList<EntityValidator> arrayList = new ArrayList<EntityValidator>();
        arrayList.addAll(mappingBean.getValidators());
        Collections.sort(arrayList, new ValidatorComparator());
        for (EntityValidator validator : arrayList) {
            schema.addValidator(validator);
        }
    }

    private void addFieldMapping(Class<?> entityClass, String prefix, CsvFieldNameConvention fieldNameConvention, Field field, CsvFieldMappingBean fieldMappingBean, List<FieldMapping> fieldMappings) {
        if (fieldMappingBean.isIgnoreSet() && fieldMappingBean.isIgnore()) {
            return;
        }
        FieldMapping mapping = this.getFieldMapping(entityClass, field, fieldMappingBean, prefix, fieldNameConvention);
        fieldMappings.add(mapping);
    }

    private FieldMapping getFieldMapping(Class<?> entityClass, Field field, CsvFieldMappingBean fieldMappingBean, String prefix, CsvFieldNameConvention fieldNameConvention) {
        FieldMapping mapping = null;
        String objFieldName = field.getName();
        Class<?> objFieldType = field.getType();
        Object csvFieldName = prefix + this.getObjectFieldNameAsCSVFieldName(objFieldName, fieldNameConvention);
        boolean required = true;
        if (fieldMappingBean.isOptionalSet()) {
            boolean bl = required = !fieldMappingBean.isOptional();
        }
        if (fieldMappingBean.isNameSet()) {
            csvFieldName = fieldMappingBean.getName();
        }
        if (fieldMappingBean.isMappingSet()) {
            FieldMappingFactory factory = fieldMappingBean.getMapping();
            mapping = factory.createFieldMapping(this, entityClass, (String)csvFieldName, objFieldName, objFieldType, required);
        }
        if (mapping == null) {
            DefaultFieldMapping m = new DefaultFieldMapping(entityClass, (String)csvFieldName, objFieldName, objFieldType, required);
            mapping = m;
        }
        if (mapping instanceof AbstractFieldMapping) {
            AbstractFieldMapping fm = (AbstractFieldMapping)mapping;
            if (fieldMappingBean.isOrderSet()) {
                fm.setOrder(fieldMappingBean.getOrder());
            }
            if (fieldMappingBean.isAlwaysIncludeInOutputSet()) {
                fm.setAlwaysIncludeInOutput(fieldMappingBean.isAlwaysIncludeInOutput());
            }
            if (fieldMappingBean.getDefaultValue() != null) {
                fm.setDefaultValue(fieldMappingBean.getDefaultValue());
            }
            try {
                String name = field.getName();
                String isFieldSet = "is" + Character.toUpperCase(name.charAt(0)) + name.substring(1) + "Set";
                Method method = entityClass.getMethod(isFieldSet, new Class[0]);
                if (method != null && (method.getReturnType() == Boolean.class || method.getReturnType() == Boolean.TYPE)) {
                    fm.setIsSetMethod(method);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return mapping;
    }

    private String getEntityClassAsEntityName(Class<?> entityClass) {
        String name = entityClass.getName();
        int index = name.lastIndexOf(".");
        if (index != -1) {
            name = name.substring(index + 1);
        }
        return name;
    }

    private String getObjectFieldNameAsCSVFieldName(String fieldName, CsvFieldNameConvention fieldNameConvention) {
        if (fieldNameConvention == CsvFieldNameConvention.CAMEL_CASE) {
            return fieldName;
        }
        if (fieldNameConvention == CsvFieldNameConvention.CAPITALIZED_CAMEL_CASE) {
            return fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        }
        StringBuilder b = new StringBuilder();
        boolean wasUpperCase = false;
        for (int i = 0; i < fieldName.length(); ++i) {
            char c = fieldName.charAt(i);
            boolean isUpperCase = Character.isUpperCase(c);
            if (isUpperCase) {
                c = Character.toLowerCase(c);
            }
            if (isUpperCase && !wasUpperCase) {
                b.append('_');
            }
            b.append(c);
            wasUpperCase = isUpperCase;
        }
        return b.toString();
    }

    private static class FieldMappingComparator
    implements Comparator<FieldMapping> {
        private FieldMappingComparator() {
        }

        @Override
        public int compare(FieldMapping o1, FieldMapping o2) {
            return o1.getOrder() - o2.getOrder();
        }
    }

    private static class ValidatorComparator
    implements Comparator<EntityValidator> {
        private ValidatorComparator() {
        }

        @Override
        public int compare(EntityValidator o1, EntityValidator o2) {
            return o1.getOrder() - o2.getOrder();
        }
    }
}

