/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities;

import java.io.File;
import java.io.IOException;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.CsvEntityContextImpl;
import org.onebusaway.csv_entities.EntityHandler;
import org.onebusaway.csv_entities.FileOutputStrategy;
import org.onebusaway.csv_entities.IndividualCsvEntityWriter;
import org.onebusaway.csv_entities.OutputStrategy;
import org.onebusaway.csv_entities.ZipOutputStrategy;
import org.onebusaway.csv_entities.schema.DefaultEntitySchemaFactory;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.ExcludeOptionalAndMissingEntitySchemaFactory;

public class CsvEntityWriter
implements EntityHandler {
    private EntitySchemaFactory _entitySchemaFactory = new DefaultEntitySchemaFactory();
    private ExcludeOptionalAndMissingEntitySchemaFactory _excludeOptionalAndMissing = null;
    private CsvEntityContext _context = new CsvEntityContextImpl();
    private OutputStrategy _outputStrategy = null;

    public EntitySchemaFactory getEntitySchemaFactory() {
        return this._entitySchemaFactory;
    }

    public void setEntitySchemaFactory(EntitySchemaFactory entitySchemaFactory) {
        this._entitySchemaFactory = entitySchemaFactory;
    }

    public void setOutputLocation(File path) {
        this._outputStrategy = path.getName().endsWith(".zip") ? ZipOutputStrategy.create(path) : new FileOutputStrategy(path);
    }

    public void excludeOptionalAndMissingFields(Class<?> entityType, Iterable<Object> entities) {
        if (this._excludeOptionalAndMissing == null) {
            this._excludeOptionalAndMissing = new ExcludeOptionalAndMissingEntitySchemaFactory(this._entitySchemaFactory);
        }
        this._excludeOptionalAndMissing.scanEntities(entityType, entities);
    }

    @Override
    public void handleEntity(Object entity) {
        Class<?> entityType = entity.getClass();
        EntitySchemaFactory schemaFactory = this._excludeOptionalAndMissing != null ? this._excludeOptionalAndMissing : this._entitySchemaFactory;
        IndividualCsvEntityWriter writer = this._outputStrategy.getEntityWriter(schemaFactory, this._context, entityType);
        writer.handleEntity(entity);
    }

    public void flush() throws IOException {
        this._outputStrategy.flush();
    }

    public void close() throws IOException {
        this._outputStrategy.close();
    }
}

