/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities;

import java.io.PrintWriter;
import java.io.Writer;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.CsvEntityContextImpl;
import org.onebusaway.csv_entities.CsvTokenizerStrategy;
import org.onebusaway.csv_entities.EntityHandler;
import org.onebusaway.csv_entities.IndividualCsvEntityWriter;
import org.onebusaway.csv_entities.TokenizerStrategy;
import org.onebusaway.csv_entities.schema.DefaultEntitySchemaFactory;
import org.onebusaway.csv_entities.schema.EntitySchema;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;

public class CsvEntityWriterFactory {
    private EntitySchemaFactory _entitySchemaFactory = new DefaultEntitySchemaFactory();
    private CsvEntityContext _context = new CsvEntityContextImpl();
    private TokenizerStrategy _tokenizerStrategy = new CsvTokenizerStrategy();

    public EntitySchemaFactory getEntitySchemaFactory() {
        return this._entitySchemaFactory;
    }

    public void setEntitySchemaFactory(EntitySchemaFactory entitySchemaFactory) {
        this._entitySchemaFactory = entitySchemaFactory;
    }

    public CsvEntityContext getContext() {
        return this._context;
    }

    public void setContext(CsvEntityContext context) {
        this._context = context;
    }

    public void setTokenizerStrategy(TokenizerStrategy tokenizerStrategy) {
        this._tokenizerStrategy = tokenizerStrategy;
    }

    public EntityHandler createWriter(Class<?> entityType, Writer writer) {
        EntitySchema schema = this._entitySchemaFactory.getSchema(entityType);
        IndividualCsvEntityWriter entityWriter = new IndividualCsvEntityWriter(this._context, schema, new PrintWriter(writer));
        if (this._tokenizerStrategy != null) {
            entityWriter.setTokenizerStrategy(this._tokenizerStrategy);
        }
        return entityWriter;
    }
}

