/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities.schema;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.exceptions.CsvEntityException;
import org.onebusaway.csv_entities.exceptions.IntrospectionException;
import org.onebusaway.csv_entities.schema.AbstractFieldMapping;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.csv_entities.schema.FieldMappingFactory;

public class DateFieldMappingFactory
implements FieldMappingFactory {
    @Override
    public FieldMapping createFieldMapping(EntitySchemaFactory schemaFactory, Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        Field field = null;
        try {
            field = entityType.getDeclaredField(objFieldName);
        }
        catch (Exception ex) {
            throw new IntrospectionException(entityType, (Throwable)ex);
        }
        DateFormatAnnotation formatAnnotation = field.getAnnotation(DateFormatAnnotation.class);
        if (formatAnnotation == null) {
            throw new DateFieldMappingException(entityType, "missing required @DateFormatAnnotation for field " + objFieldName + " of type " + String.valueOf(entityType));
        }
        boolean isLongType = false;
        if (objFieldType == Long.class || objFieldType == Long.TYPE) {
            isLongType = true;
        } else if (objFieldType != Date.class) {
            throw new DateFieldMappingException(entityType, "expected that field " + objFieldName + " of type " + String.valueOf(entityType) + " is Date or long, but instead was " + String.valueOf(objFieldType));
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatAnnotation.value());
        return new FieldMappingImpl(entityType, csvFieldName, objFieldName, required, dateFormat, isLongType);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface DateFormatAnnotation {
        public String value();
    }

    public static class DateFieldMappingException
    extends CsvEntityException {
        private static final long serialVersionUID = 1L;

        public DateFieldMappingException(Class<?> entityType, String message) {
            super(entityType, message);
        }

        public DateFieldMappingException(Class<?> entityType, String message, Throwable cause) {
            super(entityType, message, cause);
        }
    }

    private static class FieldMappingImpl
    extends AbstractFieldMapping {
        private DateFormat _dateFormat;
        private boolean _isLongType;

        public FieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName, boolean required, DateFormat dateFormat, boolean isLongType) {
            super(entityType, csvFieldName, objFieldName, required);
            this._dateFormat = dateFormat;
            this._isLongType = isLongType;
        }

        @Override
        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) throws CsvEntityException {
            if (this.isMissingAndOptional(csvValues)) {
                return;
            }
            String dateAsString = (String)csvValues.get(this._csvFieldName);
            try {
                Date value = this._dateFormat.parse(dateAsString);
                if (this._isLongType) {
                    object.setPropertyValue(this._objFieldName, value.getTime());
                } else {
                    object.setPropertyValue(this._objFieldName, value);
                }
            }
            catch (ParseException e) {
                throw new DateFieldMappingException(this._entityType, "error parsing data value " + dateAsString, e);
            }
        }

        @Override
        public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) throws CsvEntityException {
            if (this.isMissingAndOptional(object)) {
                return;
            }
            Object obj = object.getPropertyValue(this._objFieldName);
            Date date = null;
            date = this._isLongType ? new Date((Long)obj) : (Date)obj;
            String dateAsString = this._dateFormat.format(date);
            csvValues.put(this._csvFieldName, dateAsString);
        }
    }
}

