/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.onebusaway.gtfs.impl.GtfsRelationalDaoImpl;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.serialization.GtfsWriter;
import org.onebusaway.gtfs.services.GenericMutableDao;
import org.onebusaway.gtfs.services.GtfsDao;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.AgencyMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.AreaMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.EntityMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.FareAttributeMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.FareRuleMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.FeedInfoMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.FrequencyMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.RouteMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.ServiceCalendarMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.ShapePointMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.StopMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.TransferMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.TripMergeStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsMerger {
    private static Logger _log = LoggerFactory.getLogger(GtfsMerger.class);
    private static final String _alphaPrefix = "abcdefghijklmnopqrstuvwxyz";
    private static final NumberFormat _numberPrefixFormat = new DecimalFormat("00");
    private EntityMergeStrategy _agencyStrategy = new AgencyMergeStrategy();
    private EntityMergeStrategy _areaStrategy = new AreaMergeStrategy();
    private EntityMergeStrategy _stopStrategy = new StopMergeStrategy();
    private EntityMergeStrategy _serviceCalendarStrategy = new ServiceCalendarMergeStrategy();
    private EntityMergeStrategy _routeStrategy = new RouteMergeStrategy();
    private EntityMergeStrategy _tripStrategy = new TripMergeStrategy();
    private EntityMergeStrategy _shapePointStrategy = new ShapePointMergeStrategy();
    private EntityMergeStrategy _frequencyStrategy = new FrequencyMergeStrategy();
    private EntityMergeStrategy _transferStrategy = new TransferMergeStrategy();
    private EntityMergeStrategy _fareAttributeStrategy = new FareAttributeMergeStrategy();
    private EntityMergeStrategy _fareRuleStrategy = new FareRuleMergeStrategy();
    private EntityMergeStrategy _feedInfoStrategy = new FeedInfoMergeStrategy();

    public void setAgencyStrategy(EntityMergeStrategy agencyStrategy) {
        this._agencyStrategy = agencyStrategy;
    }

    public void setStopStrategy(EntityMergeStrategy stopsStrategy) {
        this._stopStrategy = stopsStrategy;
    }

    public void setServiceCalendarStrategy(EntityMergeStrategy serviceCalendarStrategy) {
        this._serviceCalendarStrategy = serviceCalendarStrategy;
    }

    public void setRouteStrategy(EntityMergeStrategy routeStrategy) {
        this._routeStrategy = routeStrategy;
    }

    public void setTripStrategy(EntityMergeStrategy tripStrategy) {
        this._tripStrategy = tripStrategy;
    }

    public void setShapePointStrategy(EntityMergeStrategy shapePointStrategy) {
        this._shapePointStrategy = shapePointStrategy;
    }

    public void setFrequencyStrategy(EntityMergeStrategy frequencyStrategy) {
        this._frequencyStrategy = frequencyStrategy;
    }

    public void setTransferStrategy(EntityMergeStrategy transferStrategy) {
        this._transferStrategy = transferStrategy;
    }

    public void setFareAttributeStrategy(EntityMergeStrategy fareAttributeStrategy) {
        this._fareAttributeStrategy = fareAttributeStrategy;
    }

    public void setFareRuleStrategy(EntityMergeStrategy fareRuleStrategy) {
        this._fareRuleStrategy = fareRuleStrategy;
    }

    public void setAreaStrategy(AreaMergeStrategy areaStrategy) {
        this._areaStrategy = areaStrategy;
    }

    public void setFeedInfoStrategy(EntityMergeStrategy feedInfoStrategy) {
        this._feedInfoStrategy = feedInfoStrategy;
    }

    public EntityMergeStrategy getEntityMergeStrategyForEntityType(Class<?> entityType) {
        ArrayList<EntityMergeStrategy> strategies = new ArrayList<EntityMergeStrategy>();
        this.buildStrategies(strategies);
        for (EntityMergeStrategy strategy : strategies) {
            HashSet entityTypes = new HashSet();
            strategy.getEntityTypes(entityTypes);
            if (!entityTypes.contains(entityType)) continue;
            return strategy;
        }
        return null;
    }

    public void run(List<File> inputPaths, File outputPath) throws IOException {
        GtfsRelationalDaoImpl mergedDao = new GtfsRelationalDaoImpl();
        mergedDao.setPackShapePoints(true);
        mergedDao.setPackStopTimes(true);
        ArrayList<EntityMergeStrategy> strategies = new ArrayList<EntityMergeStrategy>();
        this.buildStrategies(strategies);
        HashMap rawEntityIdMapsByMergeStrategy = new HashMap();
        for (EntityMergeStrategy strategy : strategies) {
            rawEntityIdMapsByMergeStrategy.put(strategy, new HashMap());
        }
        long newestFile = Long.MIN_VALUE;
        for (int index = inputPaths.size() - 1; index >= 0; --index) {
            File inputPath = inputPaths.get(index);
            String prefix = this.getIndexAsPrefix(index, inputPaths.size());
            FileTime fileTime = null;
            if (inputPath.isFile() && (fileTime = (FileTime)Files.readAttributes(inputPath.toPath(), "lastModifiedTime", new LinkOption[0]).get("lastModifiedTime")) != null && fileTime.toMillis() > newestFile) {
                newestFile = fileTime.toMillis();
            }
            _log.info("reading input: " + String.valueOf(inputPath) + " with lastModifiedTime " + String.valueOf(fileTime));
            GtfsReader reader = new GtfsReader();
            reader.setInputLocation(inputPath);
            GtfsRelationalDaoImpl dao = new GtfsRelationalDaoImpl();
            dao.setPackShapePoints(true);
            dao.setPackStopTimes(true);
            reader.setEntityStore((GenericMutableDao)dao);
            reader.run();
            for (EntityMergeStrategy strategy : strategies) {
                _log.info("strategy=" + String.valueOf(strategy.getClass()));
                GtfsMergeContext context = new GtfsMergeContext((GtfsRelationalDao)dao, (GtfsMutableRelationalDao)mergedDao, prefix, (Map)rawEntityIdMapsByMergeStrategy.get(strategy));
                strategy.merge(context);
            }
        }
        _log.info("writing merged output: " + String.valueOf(outputPath));
        GtfsWriter writer = new GtfsWriter();
        writer.setOutputLocation(outputPath);
        writer.run((GtfsDao)mergedDao);
        if (outputPath.isFile()) {
            _log.info("setting merged file lastModified to " + String.valueOf(new Date(newestFile)));
            Files.setAttribute(outputPath.toPath(), "lastModifiedTime", FileTime.fromMillis(newestFile), new LinkOption[0]);
        } else {
            _log.info("outputPath not a file, skipping setting lastModified");
        }
    }

    private String getIndexAsPrefix(int index, int total) {
        if (total <= _alphaPrefix.length()) {
            return Character.toString(_alphaPrefix.charAt(index)) + "-";
        }
        return _numberPrefixFormat.format(index) + "-";
    }

    private void buildStrategies(List<EntityMergeStrategy> strategies) {
        strategies.add(this._agencyStrategy);
        strategies.add(this._areaStrategy);
        strategies.add(this._stopStrategy);
        strategies.add(this._serviceCalendarStrategy);
        strategies.add(this._routeStrategy);
        strategies.add(this._tripStrategy);
        strategies.add(this._shapePointStrategy);
        strategies.add(this._frequencyStrategy);
        strategies.add(this._transferStrategy);
        strategies.add(this._fareAttributeStrategy);
        strategies.add(this._fareRuleStrategy);
        strategies.add(this._feedInfoStrategy);
    }
}

