/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies;

import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.BeanWrapperFactory;
import org.onebusaway.gtfs.impl.GtfsRelationalDaoImpl;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_merge.GtfsMergeContext;

public class MergeSupport {
    public static <T> void bulkReplaceValueInProperties(Iterable<T> elements, Object oldValue, Object newValue, String ... properties) {
        for (T element : elements) {
            BeanWrapper wrapped = BeanWrapperFactory.wrap(element);
            for (String property : properties) {
                Object value = wrapped.getPropertyValue(property);
                if (!oldValue.equals(value)) continue;
                wrapped.setPropertyValue(property, newValue);
            }
        }
    }

    public static AgencyAndId renameAgencyAndId(GtfsMergeContext context, AgencyAndId id) {
        return MergeSupport.renameAgencyAndId(context.getPrefix(), id);
    }

    public static AgencyAndId renameAgencyAndId(String prefix, AgencyAndId id) {
        return new AgencyAndId(id.getAgencyId(), prefix + id.getId());
    }

    public static void clearCaches(GtfsRelationalDao source) {
        if (source instanceof GtfsRelationalDaoImpl) {
            GtfsRelationalDaoImpl impl = (GtfsRelationalDaoImpl)source;
            impl.clearAllCaches();
        }
    }

    public static String noNull(String name) {
        return name == null ? "" : name;
    }
}

