/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.services.GtfsRelationalDao;

public class CacheByEntity<S extends IdentityBean<?>, T> {
    private CacheGetter<S, T> _getter;
    private Map<Key, T> _map = new ConcurrentHashMap<Key, T>();

    public CacheByEntity(CacheGetter<S, T> getter) {
        this._getter = getter;
    }

    public T getItemForEntity(GtfsRelationalDao dao, S bean) {
        Key key = new Key(this, dao, (IdentityBean<?>)bean);
        T item = this._map.get(key);
        if (item != null) {
            return item;
        }
        item = this._getter.getItemForEntity(dao, bean);
        if (item != null) {
            this._map.put(key, item);
        }
        return item;
    }

    public static interface CacheGetter<S extends IdentityBean<?>, T> {
        public T getItemForEntity(GtfsRelationalDao var1, S var2);
    }

    private class Key {
        GtfsRelationalDao _dao;
        IdentityBean<?> _bean;

        Key(CacheByEntity cacheByEntity, GtfsRelationalDao dao, IdentityBean<?> bean) {
            this._dao = dao;
            this._bean = bean;
        }

        public int hashCode() {
            return this._dao.hashCode() * 71 + 700241 * this._bean.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            if (!((Key)o)._dao.equals((Object)this._dao)) {
                return false;
            }
            return ((Key)o)._bean.equals(this._bean);
        }
    }
}

