/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies.scoring;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.BeanWrapperFactory;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.scoring.DuplicateScoringStrategy;

public class AndDuplicateScoringStrategy<T>
implements DuplicateScoringStrategy<T> {
    private final List<DuplicateScoringStrategy<T>> strategies = new ArrayList<DuplicateScoringStrategy<T>>();

    public void addPropertyMatch(String property) {
        this.addStrategy(new PropertyMatchScoringStrategy(property));
    }

    public void addStrategy(DuplicateScoringStrategy<T> strategy) {
        this.strategies.add(strategy);
    }

    @Override
    public double score(GtfsMergeContext context, T source, T target) {
        double score = 1.0;
        for (DuplicateScoringStrategy<T> strategy : this.strategies) {
            if ((score *= strategy.score(context, source, target)) == 0.0) break;
        }
        return score;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("strategies", this.strategies).toString();
    }

    private static class PropertyMatchScoringStrategy<T>
    implements DuplicateScoringStrategy<T> {
        private final String property;

        public PropertyMatchScoringStrategy(String property) {
            this.property = property;
        }

        @Override
        public double score(GtfsMergeContext context, T source, T target) {
            BeanWrapper wrappedA = BeanWrapperFactory.wrap(source);
            BeanWrapper wrappedB = BeanWrapperFactory.wrap(target);
            Object valueA = wrappedA.getPropertyValue(this.property);
            Object valueB = wrappedB.getPropertyValue(this.property);
            return valueA == null && valueB == null || valueA != null && valueA.equals(valueB) ? 1.0 : 0.0;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("property", (Object)this.property).toString();
        }
    }
}

