/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies.scoring;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.scoring.DuplicateScoringStrategy;

public class StopDistanceDuplicateScoringStrategy
implements DuplicateScoringStrategy<Stop> {
    @Override
    public double score(GtfsMergeContext context, Stop source, Stop target) {
        double distance = this.distance(source.getLat(), source.getLon(), target.getLat(), target.getLon());
        if (distance < 50.0) {
            return 1.0;
        }
        if (distance < 100.0) {
            return 0.75;
        }
        if (distance < 500.0) {
            return 0.5;
        }
        return 0.0;
    }

    private double distance(double lat1, double lon1, double lat2, double lon2) {
        double radius = 6371010.0;
        lat1 = Math.toRadians(lat1);
        lon1 = Math.toRadians(lon1);
        lat2 = Math.toRadians(lat2);
        lon2 = Math.toRadians(lon2);
        double deltaLon = lon2 - lon1;
        double y = Math.sqrt(StopDistanceDuplicateScoringStrategy.p2(Math.cos(lat2) * Math.sin(deltaLon)) + StopDistanceDuplicateScoringStrategy.p2(Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(deltaLon)));
        double x = Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(deltaLon);
        return radius * Math.atan2(y, x);
    }

    private static double p2(double a) {
        return a * a;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).toString();
    }
}

