/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.onebusaway.collections.MappingLibrary;
import org.onebusaway.collections.Max;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.AbstractSingleEntityMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.EDuplicateDetectionStrategy;
import org.onebusaway.gtfs_merge.strategies.EDuplicateRenamingStrategy;
import org.onebusaway.gtfs_merge.strategies.MergeSupport;
import org.onebusaway.gtfs_merge.strategies.scoring.AndDuplicateScoringStrategy;
import org.onebusaway.gtfs_merge.strategies.scoring.DuplicateScoringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIdentifiableSingleEntityMergeStrategy<T extends IdentityBean<?>>
extends AbstractSingleEntityMergeStrategy<T> {
    private static Logger _log = LoggerFactory.getLogger(AbstractIdentifiableSingleEntityMergeStrategy.class);
    protected AndDuplicateScoringStrategy<T> _duplicateScoringStrategy = new AndDuplicateScoringStrategy();

    public AbstractIdentifiableSingleEntityMergeStrategy(Class<T> entityType) {
        super(entityType);
    }

    @Override
    protected EDuplicateDetectionStrategy pickBestDuplicateDetectionStrategy(GtfsMergeContext context) {
        GtfsRelationalDao source = context.getSource();
        GtfsMutableRelationalDao target = context.getTarget();
        if (target.getAllEntitiesForType(this._entityType).isEmpty() || source.getAllEntitiesForType(this._entityType).isEmpty()) {
            return EDuplicateDetectionStrategy.NONE;
        }
        if (this.hasLikelyIdentifierOverlap(context)) {
            return EDuplicateDetectionStrategy.IDENTITY;
        }
        if (this.hasLikelyFuzzyOverlap(context)) {
            return EDuplicateDetectionStrategy.FUZZY;
        }
        return EDuplicateDetectionStrategy.NONE;
    }

    private boolean hasLikelyIdentifierOverlap(GtfsMergeContext context) {
        GtfsRelationalDao source = context.getSource();
        GtfsMutableRelationalDao target = context.getTarget();
        Collection targetEntities = target.getAllEntitiesForType(this._entityType);
        Collection sourceEntities = source.getAllEntitiesForType(this._entityType);
        Map sourceById = MappingLibrary.mapToValue((Iterable)targetEntities, (String)"id");
        Map targetById = MappingLibrary.mapToValue((Iterable)sourceEntities, (String)"id");
        HashSet commonIds = new HashSet();
        double elementOvelapScore = DuplicateScoringSupport.scoreElementOverlap(sourceById.keySet(), targetById.keySet(), commonIds);
        if (commonIds.isEmpty() || elementOvelapScore < this._minElementsInCommonScoreForAutoDetect) {
            return false;
        }
        double totalScore = 0.0;
        for (Serializable id : commonIds) {
            IdentityBean targetEntity = (IdentityBean)sourceById.get(id);
            IdentityBean sourceEntity = (IdentityBean)targetById.get(id);
            totalScore += this._duplicateScoringStrategy.score(context, sourceEntity, targetEntity);
        }
        return (totalScore /= (double)commonIds.size()) > this._minElementsDuplicateScoreForAutoDetect;
    }

    private boolean hasLikelyFuzzyOverlap(GtfsMergeContext context) {
        GtfsRelationalDao source = context.getSource();
        GtfsMutableRelationalDao target = context.getTarget();
        Collection targetEntities = target.getAllEntitiesForType(this._entityType);
        Collection sourceEntities = source.getAllEntitiesForType(this._entityType);
        double duplicateElements = 0.0;
        double totalScore = 0.0;
        int cpus = Runtime.getRuntime().availableProcessors();
        int start = 0;
        int end = targetEntities.size() / cpus;
        int increment = targetEntities.size() / cpus;
        ExecutorService executorService = Executors.newFixedThreadPool(cpus);
        ArrayList<Result> results = new ArrayList<Result>(cpus);
        if (end < 10) {
            HashSet remainingSourceEntities = new HashSet(sourceEntities);
            Result result = new Result();
            results.add(result);
            executorService.submit(new ScoringTask<T>(context, this._duplicateScoringStrategy, targetEntities, remainingSourceEntities, 0, targetEntities.size(), this._minElementsInCommonScoreForAutoDetect, result));
        } else {
            for (int i = 0; i < cpus; ++i) {
                Collection t_targetEntities = target.getAllEntitiesForType(this._entityType);
                Collection t_sourceEntities = source.getAllEntitiesForType(this._entityType);
                HashSet t_remainingSourceEntities = new HashSet(t_sourceEntities);
                Result result = new Result();
                results.add(result);
                executorService.submit(new ScoringTask<T>(context, this._duplicateScoringStrategy, t_targetEntities, t_remainingSourceEntities, start, end, this._minElementsInCommonScoreForAutoDetect, result));
                start = end + 1;
                end += increment;
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e1) {
            return false;
        }
        int i = 0;
        for (Result result : results) {
            while (!result.isDone()) {
                try {
                    _log.info("waiting on thread[" + i + "] at " + (int)(result.getPercentComplete() * 100.0) + "% complete (" + String.valueOf(this._entityType) + ")");
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
            duplicateElements += result.getDuplicateElements();
            totalScore += result.getTotalScore();
            ++i;
        }
        executorService.shutdown();
        double elementsInCommon = (duplicateElements / (double)targetEntities.size() + duplicateElements / (double)sourceEntities.size()) / 2.0;
        if (elementsInCommon < this._minElementsInCommonScoreForAutoDetect) {
            return false;
        }
        return (totalScore /= duplicateElements) > this._minElementsDuplicateScoreForAutoDetect;
    }

    @Override
    protected IdentityBean<?> getIdentityDuplicate(GtfsMergeContext context, IdentityBean<?> entity) {
        String rawId = this.getRawId(entity.getId());
        return (IdentityBean)context.getEntityForRawId(rawId);
    }

    @Override
    protected IdentityBean<?> getFuzzyDuplicate(GtfsMergeContext context, IdentityBean<?> entity) {
        GtfsMutableRelationalDao targetDao = context.getTarget();
        Collection targets = targetDao.getAllEntitiesForType(this._entityType);
        if (targets.isEmpty()) {
            return null;
        }
        Max best = new Max();
        for (IdentityBean target : targets) {
            String targetRawId = this.getRawId(target.getId());
            if (context.isEntityJustAddedWithRawId(targetRawId)) continue;
            double score = this._duplicateScoringStrategy.score(context, entity, target);
            best.add(score, (Object)target);
        }
        if (best.getMaxValue() < this._minElementsDuplicateScoreForAutoDetect) {
            return null;
        }
        return (IdentityBean)best.getMaxElement();
    }

    @Override
    protected void save(GtfsMergeContext context, IdentityBean<?> entity) {
        String rawId = this.getRawId(entity.getId());
        if (context.getEntityForRawId(rawId) != null) {
            this.rename(context, entity);
            rawId = this.getRawId(entity.getId());
        }
        context.putEntityWithRawId(rawId, entity);
        super.save(context, entity);
    }

    private String getRawId(Object id) {
        if (id instanceof String) {
            String string = (String)id;
            return string;
        }
        if (id instanceof AgencyAndId) {
            AgencyAndId andId = (AgencyAndId)id;
            return andId.getId();
        }
        throw new UnsupportedOperationException("cannot generate raw key for type: " + String.valueOf(id.getClass()));
    }

    protected void rename(GtfsMergeContext context, IdentityBean<?> entity) {
        Serializable id = entity.getId();
        if (id != null && id instanceof AgencyAndId) {
            AgencyAndId newAgencyAndId;
            IdentityBean<?> bean = entity;
            AgencyAndId agencyAndId = (AgencyAndId)bean.getId();
            if (this.getDuplicateRenamingStrategy() == EDuplicateRenamingStrategy.AGENCY) {
                newAgencyAndId = MergeSupport.renameAgencyAndId(agencyAndId.getAgencyId() + "-", agencyAndId);
                _log.debug(agencyAndId.toString() + " renamed(1) to " + String.valueOf(newAgencyAndId));
            } else {
                newAgencyAndId = MergeSupport.renameAgencyAndId(context, agencyAndId);
                _log.debug(agencyAndId.toString() + " renamed(2) to " + String.valueOf(newAgencyAndId));
            }
            bean.setId((Serializable)newAgencyAndId);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("entity", (Object)this._entityType.getSimpleName()).append("duplicateScoring", this._duplicateScoringStrategy).append("duplicateDetection", (Object)this._duplicateDetectionStrategy).toString();
    }

    private static class Result {
        private double duplicateElements = 0.0;
        private double totalScore = 0.0;
        private boolean done = false;
        private double percentComplete = 0.0;

        public double getDuplicateElements() {
            return this.duplicateElements;
        }

        public void setDuplicateElements(double duplicateElements) {
            this.duplicateElements = duplicateElements;
        }

        public double getTotalScore() {
            return this.totalScore;
        }

        public void setTotalScore(double totalScore) {
            this.totalScore = totalScore;
        }

        public void setDone() {
            this.done = true;
        }

        public boolean isDone() {
            return this.done;
        }

        public double getPercentComplete() {
            return this.percentComplete;
        }

        public void setPercentComplete(double percentComplete) {
            this.percentComplete = percentComplete;
        }
    }

    public static class ScoringTask<T>
    implements Runnable {
        private GtfsMergeContext context;
        protected AndDuplicateScoringStrategy<T> duplicateScoringStrategy;
        private Collection<T> targetEntities;
        private Collection<T> remainingSourceEntities;
        private int start;
        private int end;
        private double min;
        private Result result;

        public Result getResult() {
            return this.result;
        }

        public ScoringTask(GtfsMergeContext context, AndDuplicateScoringStrategy<T> duplicateScoringStrategy, Collection<T> targetEntities, Collection<T> remainingSourceEntities, int start, int end, double min, Result result) {
            this.context = context;
            this.duplicateScoringStrategy = duplicateScoringStrategy;
            this.targetEntities = targetEntities;
            this.remainingSourceEntities = remainingSourceEntities;
            this.start = start;
            this.end = end;
            this.result = result;
        }

        @Override
        public void run() {
            try {
                this.score(this.context, this.duplicateScoringStrategy, this.targetEntities, this.remainingSourceEntities, this.start, this.end, this.min, this.result);
            }
            catch (Throwable t) {
                _log.error("scoring thread broke:", t);
            }
            finally {
                this.result.setDone();
            }
        }

        private void score(GtfsMergeContext context, AndDuplicateScoringStrategy<T> duplicateScoringStrategy, Collection<T> targetEntities, Collection<T> remainingSourceEntities, int start, int end, double min, Result result) {
            int i;
            double duplicateElements = 0.0;
            double totalScore = 0.0;
            Iterator<T> iterator = targetEntities.iterator();
            for (i = 0; i < start; ++i) {
                iterator.next();
            }
            for (i = start; i < end; ++i) {
                if (i % 20 == 0) {
                    double percent = ((double)i - (double)start) / (double)(end - start);
                    result.setPercentComplete(percent);
                }
                T targetEntity = iterator.next();
                Max best = new Max();
                for (T sourceEntity : remainingSourceEntities) {
                    double score = duplicateScoringStrategy.score(context, sourceEntity, targetEntity);
                    if (score < min) continue;
                    best.add(score, sourceEntity);
                }
                if (best.getMaxElement() == null) continue;
                duplicateElements += 1.0;
                totalScore += best.getMaxValue();
            }
            result.setDuplicateElements(duplicateElements);
            result.setTotalScore(totalScore);
        }
    }
}

