/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies;

import java.util.Collection;
import java.util.Set;
import java.util.TimeZone;
import org.onebusaway.gtfs.impl.calendar.CalendarServiceDataFactoryImpl;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.AbstractCollectionEntityMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.scoring.DuplicateScoringSupport;

public class ServiceCalendarMergeStrategy
extends AbstractCollectionEntityMergeStrategy<AgencyAndId> {
    public ServiceCalendarMergeStrategy() {
        super("calendar.txt/calendar_dates.txt service_id");
    }

    @Override
    public void getEntityTypes(Collection<Class<?>> entityTypes) {
        entityTypes.add(ServiceCalendar.class);
        entityTypes.add(ServiceCalendarDate.class);
    }

    @Override
    protected Collection<AgencyAndId> getKeys(GtfsRelationalDao dao) {
        return dao.getAllServiceIds();
    }

    @Override
    protected double scoreDuplicateKey(GtfsMergeContext context, AgencyAndId key) {
        Set<ServiceDate> sourceServiceDates = this.getServiceDatesForServiceId(context.getSource(), key);
        Set<ServiceDate> targetServiceDates = this.getServiceDatesForServiceId((GtfsRelationalDao)context.getTarget(), key);
        return DuplicateScoringSupport.scoreElementOverlap(sourceServiceDates, targetServiceDates);
    }

    private Set<ServiceDate> getServiceDatesForServiceId(GtfsRelationalDao dao, AgencyAndId key) {
        CalendarServiceDataFactoryImpl factory = new CalendarServiceDataFactoryImpl();
        factory.setGtfsDao(dao);
        return factory.getServiceDatesForServiceId(key, TimeZone.getDefault());
    }

    @Override
    protected void renameKey(GtfsMergeContext context, AgencyAndId oldId, AgencyAndId newId) {
        GtfsRelationalDao source = context.getSource();
        ServiceCalendar calendar = source.getCalendarForServiceId(oldId);
        if (calendar != null) {
            calendar.setServiceId(newId);
        }
        for (ServiceCalendarDate calendarDate : source.getCalendarDatesForServiceId(oldId)) {
            calendarDate.setServiceId(newId);
        }
        for (Trip trip : source.getTripsForServiceId(oldId)) {
            trip.setServiceId(newId);
        }
    }

    @Override
    protected void saveElementsForKey(GtfsMergeContext context, AgencyAndId serviceId) {
        GtfsRelationalDao source = context.getSource();
        GtfsMutableRelationalDao target = context.getTarget();
        ServiceCalendar calendar = source.getCalendarForServiceId(serviceId);
        if (calendar != null) {
            calendar.setId(Integer.valueOf(0));
            target.saveEntity((Object)calendar);
        }
        for (ServiceCalendarDate calendarDate : source.getCalendarDatesForServiceId(serviceId)) {
            calendarDate.setId(Integer.valueOf(0));
            target.saveEntity((Object)calendarDate);
        }
    }
}

