/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies;

import org.onebusaway.gtfs.model.FeedInfo;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.AbstractIdentifiableSingleEntityMergeStrategy;

public class FeedInfoMergeStrategy
extends AbstractIdentifiableSingleEntityMergeStrategy<FeedInfo> {
    public FeedInfoMergeStrategy() {
        super(FeedInfo.class);
        this._duplicateScoringStrategy.addPropertyMatch("publisherName");
        this._duplicateScoringStrategy.addPropertyMatch("publisherUrl");
        this._duplicateScoringStrategy.addPropertyMatch("lang");
    }

    @Override
    protected void replaceDuplicateEntry(GtfsMergeContext context, FeedInfo oldEntity, FeedInfo newEntity) {
        if (oldEntity.getVersion() != null && newEntity.getVersion() != null) {
            newEntity.setVersion(oldEntity.getVersion() + ":" + newEntity.getVersion());
        }
        if (oldEntity.getStartDate() != null && newEntity.getStartDate() != null) {
            ServiceDate startDate = oldEntity.getStartDate();
            if (newEntity.getStartDate().compareTo(oldEntity.getStartDate()) < 0) {
                startDate = newEntity.getStartDate();
            }
            newEntity.setStartDate(startDate);
        }
        if (oldEntity.getEndDate() != null && newEntity.getEndDate() != null) {
            ServiceDate endDate = newEntity.getEndDate();
            if (oldEntity.getEndDate().compareTo(newEntity.getEndDate()) > 0) {
                endDate = oldEntity.getEndDate();
            }
            newEntity.setEndDate(endDate);
        }
    }
}

