/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies;

import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.AbstractSingleEntityMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.EDuplicateDetectionStrategy;

public abstract class AbstractNonIdentifiableSingleEntityMergeStrategy<T>
extends AbstractSingleEntityMergeStrategy<T> {
    public AbstractNonIdentifiableSingleEntityMergeStrategy(Class<T> entityType) {
        super(entityType);
    }

    @Override
    protected EDuplicateDetectionStrategy pickBestDuplicateDetectionStrategy(GtfsMergeContext context) {
        return EDuplicateDetectionStrategy.IDENTITY;
    }

    @Override
    protected IdentityBean<?> getIdentityDuplicate(GtfsMergeContext context, IdentityBean<?> newEntity) {
        GtfsMutableRelationalDao target = context.getTarget();
        for (Object entity : target.getAllEntitiesForType(this._entityType)) {
            if (!this.entitiesAreIdentical(entity, newEntity)) continue;
            return (IdentityBean)entity;
        }
        return null;
    }

    protected abstract boolean entitiesAreIdentical(T var1, T var2);

    @Override
    protected void replaceDuplicateEntry(GtfsMergeContext context, T oldEntity, T newEntity) {
    }

    protected void rename(GtfsMergeContext context, IdentityBean<?> entity) {
        throw new UnsupportedOperationException();
    }
}

