/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies;

import java.util.Collection;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.EntityMergeStrategy;

public class MetadataMergeStrategy
implements EntityMergeStrategy {
    @Override
    public void getEntityTypes(Collection<Class<?>> entityTypes) {
    }

    @Override
    public void merge(GtfsMergeContext context) {
        GtfsRelationalDao source = context.getSource();
        GtfsMutableRelationalDao target = context.getTarget();
        String agencyStr = this.getAgencyStr(source);
        for (String filename : source.getOptionalMetadataFilenames()) {
            if (!source.hasMetadata(filename)) continue;
            StringBuffer content = new StringBuffer();
            content.append("\n====== ");
            content.append(agencyStr);
            content.append(" ======\n");
            content.append(source.getMetadata(filename));
            if (target.hasMetadata(filename)) {
                content.append(target.getMetadata(filename));
            }
            target.addMetadata(filename, content.toString());
        }
    }

    private String getAgencyStr(GtfsRelationalDao source) {
        int agencyCount = source.getAllAgencies().size();
        if (agencyCount == 0) {
            return "";
        }
        if (agencyCount == 1) {
            return ((Agency)source.getAllAgencies().iterator().next()).getId();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (Agency agency : source.getAllAgencies()) {
            sb.append(agency).append(",");
        }
        return sb.substring(0, sb.length() - 2) + "]";
    }
}

