/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies.scoring;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;

public class DuplicateScoringSupport {
    public static <T> double scoreElementOverlap(Collection<T> a, Collection<T> b) {
        return DuplicateScoringSupport.scoreElementOverlap(a, b, new HashSet());
    }

    public static <T> double scoreElementOverlap(Collection<T> a, Collection<T> b, Set<T> common) {
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0;
        }
        common.clear();
        common.addAll(a);
        common.retainAll(b);
        return ((double)common.size() / (double)a.size() + (double)common.size() / (double)b.size()) / 2.0;
    }

    public static <T> double scoreElementOverlap(SortedSet<T> a, SortedSet<T> b) {
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0;
        }
        int nIntersect = DuplicateScoringSupport.calculateIntersection(a, b);
        return ((double)nIntersect / (double)a.size() + (double)nIntersect / (double)b.size()) / 2.0;
    }

    private static <T> int calculateIntersection(SortedSet<T> aSet, SortedSet<T> bSet) {
        Comparator comparator = aSet.comparator();
        Iterator a = aSet.iterator();
        Iterator b = bSet.iterator();
        int nIntersect = 0;
        Object s = a.next();
        Object t = b.next();
        while (a.hasNext() && b.hasNext()) {
            int cmp = comparator.compare(s, t);
            if (cmp == 0 && s.equals(t)) {
                ++nIntersect;
                s = a.next();
                t = b.next();
                continue;
            }
            if (cmp < 0) {
                s = a.next();
                continue;
            }
            t = b.next();
        }
        return nIntersect;
    }

    public static double scoreIntervalOverlap(int[] sourceInterval, int[] targetInterval) {
        int from = Math.max(sourceInterval[0], targetInterval[0]);
        int to = Math.min(sourceInterval[1], targetInterval[1]);
        double overlap = Math.max(to - from, 0);
        return (overlap / (double)(sourceInterval[1] - sourceInterval[0]) + overlap / (double)(targetInterval[1] - targetInterval[0])) / 2.0;
    }
}

