/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies;

import java.io.Serializable;
import java.util.Collection;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.serialization.DuplicateEntityException;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.AbstractEntityMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.EDuplicateDetectionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSingleEntityMergeStrategy<T>
extends AbstractEntityMergeStrategy {
    private static final Logger _log = LoggerFactory.getLogger(AbstractSingleEntityMergeStrategy.class);
    protected final Class<?> _entityType;

    public AbstractSingleEntityMergeStrategy(Class<T> entityType) {
        this._entityType = entityType;
    }

    @Override
    public void getEntityTypes(Collection<Class<?>> entityTypes) {
        entityTypes.add(this._entityType);
    }

    @Override
    public void merge(GtfsMergeContext context) {
        GtfsRelationalDao source = context.getSource();
        Collection entities = source.getAllEntitiesForType(this._entityType);
        for (Object entity : entities) {
            this.mergeEntity(context, (IdentityBean)entity);
        }
    }

    protected void mergeEntity(GtfsMergeContext context, IdentityBean<?> entity) {
        this.resetGeneratedIds(context, entity);
        IdentityBean<?> duplicate = this.getDuplicate(context, entity);
        if (duplicate != null) {
            // empty if block
        }
        if (duplicate != null && !this.rejectDuplicateOverDifferences(context, entity, duplicate)) {
            this.logDuplicateEntity(entity.getId());
            this.replaceDuplicateEntry(context, entity, duplicate);
            return;
        }
        this.save(context, entity);
    }

    private void logDuplicateEntity(Serializable id) {
        switch (this._logDuplicatesStrategy) {
            case NONE: {
                break;
            }
            case WARNING: {
                _log.warn("duplicate entity: type=" + String.valueOf(this._entityType) + " id=" + String.valueOf(id));
                break;
            }
            case ERROR: {
                throw new DuplicateEntityException(this._entityType, id);
            }
        }
    }

    private void resetGeneratedIds(GtfsMergeContext context, IdentityBean<?> entity) {
        Serializable id = entity.getId();
        if (id != null && id instanceof Integer) {
            IdentityBean<?> hasIntegerId = entity;
            hasIntegerId.setId((Serializable)Integer.valueOf(0));
        }
    }

    private IdentityBean<?> getDuplicate(GtfsMergeContext context, IdentityBean<?> entity) {
        EDuplicateDetectionStrategy duplicateDetectionStrategy = this.determineDuplicateDetectionStrategy(context);
        switch (duplicateDetectionStrategy) {
            case IDENTITY: {
                return this.getIdentityDuplicate(context, entity);
            }
            case FUZZY: {
                return this.getFuzzyDuplicate(context, entity);
            }
            case NONE: {
                return null;
            }
        }
        throw new IllegalStateException("unexpected duplicate detection strategy: " + String.valueOf((Object)this._duplicateDetectionStrategy));
    }

    protected abstract IdentityBean<?> getIdentityDuplicate(GtfsMergeContext var1, IdentityBean<?> var2);

    protected IdentityBean<?> getFuzzyDuplicate(GtfsMergeContext context, IdentityBean<?> entity) {
        return null;
    }

    protected boolean rejectDuplicateOverDifferences(GtfsMergeContext context, T sourceEntity, T targetDuplicate) {
        return false;
    }

    protected abstract void replaceDuplicateEntry(GtfsMergeContext var1, T var2, T var3);

    protected void save(GtfsMergeContext context, IdentityBean<?> entity) {
        GtfsMutableRelationalDao target = context.getTarget();
        target.saveEntity(entity);
    }

    @Override
    protected String getDescription() {
        String name = this._entityType.getName();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            name = name.substring(index + 1);
        }
        return name;
    }
}

