/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.FeedInfo;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.csv.CSVUtil;
import org.onebusaway.gtfs_transformer.csv.MTAStation;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MTAStationAccessibilityStrategy
implements GtfsTransformStrategy {
    private static final Logger _log = LoggerFactory.getLogger(MTAStationAccessibilityStrategy.class);
    private String stationsCsv;
    @CsvField(ignore=true)
    private Set<Stop> accessibleStops = new HashSet<Stop>();
    @CsvField(ignore=true)
    private Map<String, Stop> idToStopMap = new HashMap<String, Stop>();

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        Collection feedInfos = dao.getAllFeedInfos();
        String feed = null;
        if (feedInfos.size() > 0) {
            feed = ((FeedInfo)feedInfos.iterator().next()).getPublisherName();
        }
        for (Stop stop : dao.getAllStops()) {
            this.idToStopMap.put(stop.getId().getId(), stop);
        }
        File stationsFile = new File(this.stationsCsv);
        List<MTAStation> stations = this.getStations();
        for (MTAStation station : stations) {
            this.markStopAccessible(dao, station.getStopId(), "", station.getAda());
            if (0 == station.getAda() || 1 == station.getAda()) {
                this.markStopAccessible(dao, station.getStopId(), "N", station.getAda());
                this.markStopAccessible(dao, station.getStopId(), "S", station.getAda());
                continue;
            }
            if (2 != station.getAda()) continue;
            if (station.getAdaNorthBound() < 0) {
                this.markStopAccessible(dao, station.getStopId(), "N", 0);
            } else {
                this.markStopAccessible(dao, station.getStopId(), "N", station.getAdaNorthBound());
            }
            if (station.getAdaSouthBound() < 0) {
                this.markStopAccessible(dao, station.getStopId(), "S", 0);
                continue;
            }
            this.markStopAccessible(dao, station.getStopId(), "S", station.getAdaSouthBound());
        }
        _log.info("marking {} stops as accessible", (Object)this.accessibleStops.size());
        for (Stop accessibleStop : this.accessibleStops) {
            dao.updateEntity((Object)accessibleStop);
        }
    }

    private void markStopAccessible(GtfsMutableRelationalDao dao, String stopId, String compassDirection, int accessibilityQualifier) {
        int gtfsValue = this.convertMTAccessibilityToGTFS(accessibilityQualifier);
        String unqualifiedStopId = stopId + compassDirection;
        Stop stopForId = this.idToStopMap.get(unqualifiedStopId);
        if (stopForId == null) {
            _log.error("no such stop for stopId {}", (Object)unqualifiedStopId);
            return;
        }
        stopForId.setWheelchairBoarding(gtfsValue);
        this.accessibleStops.add(stopForId);
    }

    public int convertMTAccessibilityToGTFS(int accessibilityQualifier) {
        return switch (accessibilityQualifier) {
            case 0 -> 2;
            case 1 -> 1;
            case 2 -> 3;
            default -> 0;
        };
    }

    private List<MTAStation> getStations() {
        return CSVUtil.readCsv(MTAStation.class, this.stationsCsv);
    }

    public void setStationsCsv(String stationsCsv) {
        this.stationsCsv = stationsCsv;
    }

    private String getNamespace() {
        return System.getProperty("cloudwatch.namespace");
    }
}

