/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.List;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTripHeadsignIfNull
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(UpdateTripHeadsignIfNull.class);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        for (Trip trip : dao.getAllTrips()) {
            String tripHeadSign;
            List stopTimes;
            if (trip.getTripHeadsign() != null || (stopTimes = dao.getStopTimesForTrip(trip)) == null || stopTimes.size() <= 0 || (tripHeadSign = ((StopTime)stopTimes.getLast()).getStop().getName()) == null) continue;
            trip.setTripHeadsign(tripHeadSign);
        }
    }
}

