/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.onebusaway.csv_entities.CSVLibrary;
import org.onebusaway.csv_entities.CSVListener;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.impl.calendar.CalendarServiceDataFactoryImpl;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs.services.calendar.CalendarService;
import org.onebusaway.gtfs_transformer.services.CloudContextService;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyFutureRouteService
implements GtfsTransformStrategy {
    private final Logger _log = LoggerFactory.getLogger(VerifyFutureRouteService.class);
    private final int ACTIVE_ROUTES = 0;
    private final int ALARMING_ROUTES = 1;
    @CsvField(optional=true)
    private String problemRoutesUrl;
    @CsvField(optional=true)
    private String problemRoutesFile;

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        HashSet<String> problemRoutes = new HashSet();
        ProblemRouteListener listener = new ProblemRouteListener(this);
        try {
            if (this.problemRoutesUrl != null) {
                URL url = new URL(this.problemRoutesUrl);
                try (InputStream is = url.openStream();){
                    new CSVLibrary().parse(is, (CSVListener)listener);
                }
            }
            if (this.problemRoutesFile != null) {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.problemRoutesFile));
                new CSVLibrary().parse((InputStream)is, (CSVListener)listener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        problemRoutes = listener.returnRouteIds();
        GtfsMutableRelationalDao reference = (GtfsMutableRelationalDao)context.getReferenceReader().getEntityStore();
        CalendarService refCalendarService = CalendarServiceDataFactoryImpl.createService((GtfsRelationalDao)reference);
        String feed = CloudContextService.getLikelyFeedName(dao);
        String agencyName = ((Agency)dao.getAllAgencies().iterator().next()).getName();
        Date today = this.removeTime(new Date());
        Date tomorrow = this.removeTime(this.addDays(new Date(), 1));
        Date nextDay = this.removeTime(this.addDays(new Date(), 2));
        Date dayAfterNext = this.removeTime(this.addDays(new Date(), 3));
        int[] tripsToday = this.hasRouteServiceForDate(dao, reference, refCalendarService, today, problemRoutes);
        int[] tripsTomorrow = this.hasRouteServiceForDate(dao, reference, refCalendarService, tomorrow, problemRoutes);
        int[] tripsNextDay = this.hasRouteServiceForDate(dao, reference, refCalendarService, nextDay, problemRoutes);
        int[] tripsDayAfterNext = this.hasRouteServiceForDate(dao, reference, refCalendarService, dayAfterNext, problemRoutes);
        this._log.info("Feed for metrics: {}, agency name: {}", (Object)feed, (Object)agencyName);
        this._log.info("Active routes {}: {}, {}: {}, {}: {}, {}: {}", new Object[]{today, tripsToday[0], tomorrow, tripsTomorrow[0], nextDay, tripsNextDay[0], dayAfterNext, tripsDayAfterNext[0]});
    }

    private int[] hasRouteServiceForDate(GtfsMutableRelationalDao dao, GtfsMutableRelationalDao reference, CalendarService refCalendarService, Date testDate, Collection<String> problemRoutes) {
        AgencyAndId refAgencyAndId = ((Trip)reference.getAllTrips().iterator().next()).getId();
        int numTripsOnDate = 0;
        int activeRoutes = 0;
        int alarmingRoutes = 0;
        block0: for (Route route : dao.getAllRoutes()) {
            numTripsOnDate = 0;
            block1: for (Trip trip : dao.getTripsForRoute(route)) {
                for (ServiceCalendarDate calDate : dao.getCalendarDatesForServiceId(trip.getServiceId())) {
                    Date date = this.constructDate(calDate.getDate());
                    if (calDate.getExceptionType() != 1 || !date.equals(testDate)) continue;
                    this._log.info("ATIS has service for route: {} on {}", (Object)route.getId().getId(), (Object)testDate);
                    ++numTripsOnDate;
                    ++activeRoutes;
                    break block1;
                }
            }
            if (numTripsOnDate != 0) continue;
            this._log.info("No service for {} on {}", (Object)route.getId().getId(), (Object)testDate);
            ServiceDate sDate = this.createServiceDate(testDate);
            Route refRoute = reference.getRouteForId(new AgencyAndId(refAgencyAndId.getAgencyId(), route.getId().getId()));
            for (Trip refTrip : reference.getTripsForRoute(refRoute)) {
                Set activeDates = refCalendarService.getServiceDatesForServiceId(refTrip.getServiceId());
                if (!activeDates.contains(sDate)) continue;
                if (problemRoutes.contains(route.getId().getId())) {
                    this._log.info("On {} Reference has service for this route, but ATIS has none: {}, Trip {}, Serviceid {}", new Object[]{testDate, route.getId(), refTrip.getId(), refTrip.getServiceId()});
                    ++alarmingRoutes;
                    continue block0;
                }
                this._log.error("On {} Reference has service for this route but ATIS has none: {}, Trip {}, Serviceid {}", new Object[]{testDate, route.getId(), refTrip.getId(), refTrip.getServiceId()});
                ++alarmingRoutes;
                continue block0;
            }
        }
        return new int[]{activeRoutes, alarmingRoutes};
    }

    private Date constructDate(ServiceDate date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, date.getYear());
        calendar.set(2, date.getMonth() - 1);
        calendar.set(5, date.getDay());
        Date date1 = calendar.getTime();
        date1 = this.removeTime(date1);
        return date1;
    }

    private Date removeTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        date = calendar.getTime();
        return date;
    }

    private Date addDays(Date date, int daysToAdd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, daysToAdd);
        return cal.getTime();
    }

    private ServiceDate createServiceDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new ServiceDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    private String getTopic() {
        return System.getProperty("sns.topic");
    }

    public void setProblemRoutesUrl(String url) {
        this.problemRoutesUrl = url;
    }

    public void setProblemRoutesFile(String url) {
        this.problemRoutesFile = url;
    }

    private class ProblemRouteListener
    implements CSVListener {
        private Collection<String> routeIds = new HashSet<String>();
        private GtfsMutableRelationalDao dao;

        private ProblemRouteListener(VerifyFutureRouteService verifyFutureRouteService) {
        }

        public void handleLine(List<String> list) throws Exception {
            if (this.routeIds == null) {
                this.routeIds = list;
                return;
            }
            this.routeIds.add(list.getFirst());
        }

        public Collection<String> returnRouteIds() {
            return this.routeIds;
        }
    }
}

