/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.stream.Collectors;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.FeedInfo;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedInfoFromAgencyStrategy
implements GtfsTransformStrategy {
    private static Logger _log = LoggerFactory.getLogger(FeedInfoFromAgencyStrategy.class);
    private String agencyId;
    @CsvField(optional=true)
    private String feedVersion;
    @CsvField(optional=true)
    private String defaultLang = "en";

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        boolean foundAgency = false;
        for (Agency agency : dao.getAllAgencies()) {
            _log.info("comparing agency " + agency.getId() + " to " + this.agencyId);
            if (!agency.getId().equals(this.agencyId)) continue;
            foundAgency = true;
            _log.info("creating feed info from matched agency " + this.agencyId);
            FeedInfo info = this.getFeedInfoFromAgency(dao, agency);
            if (info.getVersion() == null) {
                this.addCreationTime(info, context);
                dao.saveOrUpdateEntity((Object)info);
                continue;
            }
            _log.info("found feedVersion " + info.getVersion() + ", abandoning");
        }
        if (!foundAgency) {
            Agency agency = (Agency)dao.getAllAgencies().iterator().next();
            FeedInfo info = this.getFeedInfoFromAgency(dao, agency);
            _log.info("creating feed info from unmatched agency " + agency.getId());
            this.addCreationTime(info, context);
            dao.saveOrUpdateEntity((Object)info);
        }
    }

    private FeedInfo getFeedInfoFromAgency(GtfsMutableRelationalDao dao, Agency agency) {
        FeedInfo info = dao.getAllFeedInfos().stream().filter(feed -> feed.getId().equals(this.agencyId)).collect(Collectors.toMap(FeedInfo::getId, feed -> feed)).get(agency.getId());
        if (info == null) {
            info = new FeedInfo();
        }
        info.setId(this.agencyId);
        info.setPublisherName(agency.getName());
        info.setPublisherUrl(agency.getUrl());
        if (agency.getLang() == null || agency.getLang().isEmpty()) {
            info.setLang(this.defaultLang);
        } else {
            info.setLang(agency.getLang());
        }
        return info;
    }

    private void addCreationTime(FeedInfo feedInfo, TransformContext context) {
        Long creationTime = (Long)context.getReader().getContext().get((Object)"lastModifiedTime");
        SimpleDateFormat df = new SimpleDateFormat("zzz: dd-MMM-yyyy HH:mm");
        if (creationTime != null) {
            _log.info("setting version to lastModifiedTime of " + String.valueOf(new Date(creationTime)));
            feedInfo.setVersion(df.format(new Date(creationTime)));
        }
    }

    public void setAgencyId(String agencyId) {
        this.agencyId = agencyId;
    }

    public void setDefaultLang(String lang) {
        this.defaultLang = lang;
    }

    public void setFeedVersion(String feedVersion) {
        this.feedVersion = feedVersion;
    }
}

