/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.FeedInfo;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Transfer;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.collections.ServiceIdKey;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityLibrary;
import org.onebusaway.gtfs_transformer.services.EntityTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class RemoveEntityUpdateStrategy
implements EntityTransformStrategy {
    private RemoveEntityLibrary _library = new RemoveEntityLibrary();

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao, Object obj) {
        if (obj instanceof Agency) {
            Agency agency = (Agency)obj;
            this._library.removeAgency(dao, agency);
        } else if (obj instanceof Route) {
            Route route = (Route)obj;
            this._library.removeRoute(dao, route);
        } else if (obj instanceof Stop) {
            Stop stop = (Stop)obj;
            this._library.removeStop(dao, stop);
        } else if (obj instanceof Trip) {
            Trip trip = (Trip)obj;
            this._library.removeTrip(dao, trip);
        } else if (obj instanceof StopTime) {
            StopTime time = (StopTime)obj;
            this._library.removeStopTime(dao, time);
        } else if (obj instanceof Frequency) {
            Frequency frequency = (Frequency)obj;
            this._library.removeFrequency(dao, frequency);
        } else if (obj instanceof ServiceCalendar) {
            ServiceCalendar calendar = (ServiceCalendar)obj;
            this._library.removeServiceCalendar(dao, calendar);
        } else if (obj instanceof ServiceCalendarDate) {
            ServiceCalendarDate date = (ServiceCalendarDate)obj;
            this._library.removeServiceCalendarDate(dao, date);
        } else if (obj instanceof ServiceIdKey) {
            ServiceIdKey key = (ServiceIdKey)obj;
            this._library.removeCalendar(dao, key.getId());
        } else if (obj instanceof Transfer) {
            Transfer transfer = (Transfer)obj;
            this._library.removeTransfer(dao, transfer);
        } else if (obj instanceof FeedInfo) {
            FeedInfo info = (FeedInfo)obj;
            this._library.removeFeedInfo(dao, info);
        } else {
            throw new NoSuchMethodError("attempt to remove entity of type " + String.valueOf(obj.getClass()));
        }
    }
}

