/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

public class SphericalGeometryLibrary {
    public static final double RADIUS_OF_EARTH_IN_KM = 6371.01;
    public static final double COS_MAX_LAT = Math.cos(0.8028514559173915);
    public static final double METERS_PER_DEGREE_AT_EQUATOR = 111319.9;

    public static double distanceFaster(double lat1, double lon1, double lat2, double lon2) {
        double lonDelta = lon2 - lon1;
        double latDelta = lat2 - lat1;
        return Math.sqrt(lonDelta * lonDelta + latDelta * latDelta) * 111319.9 * COS_MAX_LAT;
    }

    public static final double distance(double lat1, double lon1, double lat2, double lon2) {
        return SphericalGeometryLibrary.distance(lat1, lon1, lat2, lon2, 6371010.0);
    }

    public static final double distance(double lat1, double lon1, double lat2, double lon2, double radius) {
        lat1 = Math.toRadians(lat1);
        lon1 = Math.toRadians(lon1);
        lat2 = Math.toRadians(lat2);
        lon2 = Math.toRadians(lon2);
        double deltaLon = lon2 - lon1;
        double y = Math.sqrt(SphericalGeometryLibrary.p2(Math.cos(lat2) * Math.sin(deltaLon)) + SphericalGeometryLibrary.p2(Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(deltaLon)));
        double x = Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(deltaLon);
        return radius * Math.atan2(y, x);
    }

    private static final double p2(double a) {
        return a * a;
    }
}

