/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.onebusaway.collections.tuple.Pair;
import org.onebusaway.collections.tuple.Tuples;
import org.onebusaway.csv_entities.CSVLibrary;
import org.onebusaway.csv_entities.CSVListener;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.FareAttribute;
import org.onebusaway.gtfs.model.FareRule;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopMatrixFareModificationStrategy
implements GtfsTransformStrategy {
    private static final Logger _log = LoggerFactory.getLogger(StopMatrixFareModificationStrategy.class);
    private String routeId;
    private String csvUrl;
    private int initialFareId;
    @CsvField(optional=true)
    private String agencyId;
    @CsvField(optional=true)
    private String currencyType;
    @CsvField(optional=true)
    private int paymentMethod = -1;
    @CsvField(optional=true)
    private int transfers = -1;
    @CsvField(optional=true)
    private int transferDuration = -1;
    @CsvField(optional=true)
    private float youthPrice = -1.0f;
    @CsvField(optional=true)
    private float seniorPrice = -1.0f;
    @CsvField(ignore=true)
    private Route route;

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public void setCsvUrl(String csvUrl) {
        this.csvUrl = csvUrl;
    }

    public void setInitialFareId(int initialFareId) {
        this.initialFareId = initialFareId;
    }

    public void setCurrencyType(String currencyType) {
        this.currencyType = currencyType;
    }

    public void setPaymentMethod(int paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public void setTransfers(int transfers) {
        this.transfers = transfers;
    }

    public void setTransferDuration(int transferDuration) {
        this.transferDuration = transferDuration;
    }

    public void setAgencyId(String agencyId) {
        this.agencyId = agencyId;
    }

    public void setYouthPrice(float youthPrice) {
        this.youthPrice = youthPrice;
    }

    public void setSeniorPrice(float seniorPrice) {
        this.seniorPrice = seniorPrice;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        for (FareRule rule : new HashSet(dao.getAllFareRules())) {
            if (rule.getRoute() == null || !rule.getRoute().getId().getId().equals(this.routeId)) continue;
            if (!this.isExemplarSet()) {
                this.setAttributesFromExemplar(rule.getFare());
            }
            this.route = rule.getRoute();
            dao.removeEntity((IdentityBean)rule);
        }
        for (FareAttribute attr : new HashSet(dao.getAllFareAttributes())) {
            if (!dao.getFareRulesForFareAttribute(attr).isEmpty()) continue;
            dao.removeEntity((IdentityBean)attr);
        }
        FareCreationListener listener = new FareCreationListener();
        listener.setDao(dao);
        try {
            URL url = new URL(this.csvUrl);
            try (InputStream is = url.openStream();){
                new CSVLibrary().parse(is, (CSVListener)listener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        listener.flushNewFares();
    }

    private void setAttributesFromExemplar(FareAttribute attr) {
        this.agencyId = attr.getId().getAgencyId();
        this.currencyType = attr.getCurrencyType();
        this.paymentMethod = attr.getPaymentMethod();
        this.transfers = attr.getTransfers();
        if (attr.isTransferDurationSet()) {
            this.transferDuration = attr.getTransferDuration();
        }
    }

    private boolean isExemplarSet() {
        return this.agencyId != null || this.currencyType != null || this.paymentMethod != -1 || this.transfers != -1;
    }

    private class FareCreationListener
    implements CSVListener {
        private List<String> stopIds;
        private Map<Float, FareAttribute> newFareAttributes = new HashMap<Float, FareAttribute>();
        private Map<Pair<String>, FareRule> newFareRules = new HashMap<Pair<String>, FareRule>();
        int fareId;
        private GtfsMutableRelationalDao dao;

        private FareCreationListener() {
            this.fareId = StopMatrixFareModificationStrategy.this.initialFareId;
        }

        public void handleLine(List<String> list) throws Exception {
            if (this.stopIds == null) {
                this.stopIds = list;
                return;
            }
            String orig = list.getFirst();
            for (int i = 1; i < list.size(); ++i) {
                String dest = this.stopIds.get(i);
                if (orig.equals(dest)) continue;
                float price = Float.parseFloat(list.get(i));
                this.addNewFareRule(orig, dest, price);
            }
        }

        public void flushNewFares() {
            for (FareAttribute attr : this.newFareAttributes.values()) {
                this.dao.saveEntity((Object)attr);
            }
            for (FareRule rule : this.newFareRules.values()) {
                this.dao.saveEntity((Object)rule);
            }
        }

        public void setDao(GtfsMutableRelationalDao dao) {
            this.dao = dao;
        }

        private void addNewFareRule(String orig, String dest, float price) {
            String destZone;
            FareAttribute attr = this.getFareAttributeForCost(price);
            String origZone = this.getZoneForStopId(orig);
            Pair key = Tuples.pair((Object)origZone, (Object)(destZone = this.getZoneForStopId(dest)));
            FareRule rule = this.newFareRules.get(key);
            if (rule != null) {
                if (rule.getFare().getId().equals((Object)attr.getId())) {
                    _log.debug("Fare rule already exists for stops {} -> {}, skipping", (Object)orig, (Object)dest);
                } else {
                    throw new RuntimeException("Invalid fare matrix: stops with the same zone given different prices (zone " + origZone + ", " + destZone + ")");
                }
            }
            rule = new FareRule();
            rule.setFare(attr);
            rule.setRoute(StopMatrixFareModificationStrategy.this.route);
            rule.setOriginId(origZone);
            rule.setDestinationId(destZone);
            this.newFareRules.put((Pair<String>)key, rule);
        }

        private FareAttribute getFareAttributeForCost(float price) {
            if (this.newFareAttributes.get(Float.valueOf(price)) != null) {
                return this.newFareAttributes.get(Float.valueOf(price));
            }
            FareAttribute attr = new FareAttribute();
            attr.setId(new AgencyAndId(StopMatrixFareModificationStrategy.this.agencyId, Integer.toString(this.fareId++)));
            attr.setCurrencyType(StopMatrixFareModificationStrategy.this.currencyType);
            attr.setPaymentMethod(StopMatrixFareModificationStrategy.this.paymentMethod);
            attr.setTransfers(StopMatrixFareModificationStrategy.this.transfers);
            attr.setTransferDuration(StopMatrixFareModificationStrategy.this.transferDuration);
            attr.setPrice(price);
            if (StopMatrixFareModificationStrategy.this.youthPrice != -1.0f) {
                attr.setYouthPrice(StopMatrixFareModificationStrategy.this.youthPrice);
            }
            if (StopMatrixFareModificationStrategy.this.seniorPrice != -1.0f) {
                attr.setSeniorPrice(StopMatrixFareModificationStrategy.this.seniorPrice);
            }
            this.newFareAttributes.put(Float.valueOf(price), attr);
            return attr;
        }

        private String getZoneForStopId(String stopId) {
            Stop stop = this.dao.getStopForId(new AgencyAndId(StopMatrixFareModificationStrategy.this.agencyId, stopId));
            if (stop == null) {
                return null;
            }
            if (stop.getZoneId() == null || "".equals(stop.getZoneId())) {
                _log.info("Stop {} does not have zone, setting zone to stop_id", (Object)stop);
                stop.setZoneId(stop.getId().getId());
                this.dao.updateEntity((Object)stop);
            }
            return stop.getZoneId();
        }
    }
}

