/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.onebusaway.collections.beans.PropertyPathExpression;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.match.PropertyValueEntityMatch;
import org.onebusaway.gtfs_transformer.match.SimpleValueMatcher;
import org.onebusaway.gtfs_transformer.match.TypedEntityMatch;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.TrimTripTransformStrategy;

public class TrimTripFromPolygon
implements GtfsTransformStrategy {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    private final WKTReader wktReader = new WKTReader(GEOMETRY_FACTORY);
    private final TrimTripTransformStrategy strategy = new TrimTripTransformStrategy();
    private final TransformContext context = new TransformContext();
    @CsvField(optional=false)
    private String polygon;
    @CsvField(ignore=true)
    private Geometry polygonGeometry;

    public void setPolygon(String polygon) {
        this.polygon = polygon;
        this.polygonGeometry = this.buildPolygon(polygon);
        if (this.polygonGeometry == null || !this.polygonGeometry.isValid() || this.polygonGeometry.isEmpty()) {
            throw new IllegalArgumentException("The provided polygon is invalid or empty.");
        }
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext transformContext, GtfsMutableRelationalDao gtfsMutableRelationalDao) {
        for (Trip trip : gtfsMutableRelationalDao.getAllTrips()) {
            List stopTimes = gtfsMutableRelationalDao.getStopTimesForTrip(trip);
            ArrayList<StopTime> stopTimesInPolygon = new ArrayList<StopTime>();
            for (StopTime stopTime : stopTimes) {
                Stop stop = gtfsMutableRelationalDao.getStopForId(stopTime.getStop().getId());
                if (!this.insidePolygon(this.polygonGeometry, stop.getLon(), stop.getLat())) continue;
                stopTimesInPolygon.add(stopTime);
            }
            if (stopTimesInPolygon.isEmpty() || stopTimesInPolygon.size() >= stopTimes.size()) continue;
            this.applyTrimOperation(gtfsMutableRelationalDao, trip, stopTimesInPolygon);
        }
        this.strategy.run(this.context, gtfsMutableRelationalDao);
    }

    private void applyTrimOperation(GtfsMutableRelationalDao gtfs, Trip trip, List<StopTime> stopTimes) {
        TrimTripTransformStrategy.TrimOperation operation = new TrimTripTransformStrategy.TrimOperation();
        StopTime firstStopTime = stopTimes.getFirst();
        StopTime lastStopTime = stopTimes.getLast();
        if (firstStopTime.getStopSequence() > 0) {
            StopTime previousStop = (StopTime)gtfs.getStopTimesForTrip(trip).get(firstStopTime.getStopSequence() - 1);
            operation.setToStopId(previousStop.getStop().getId().getId());
        }
        if (lastStopTime.getStopSequence() < gtfs.getStopTimesForTrip(trip).size() - 1) {
            StopTime nextStop = (StopTime)gtfs.getStopTimesForTrip(trip).get(lastStopTime.getStopSequence() + 1);
            operation.setFromStopId(nextStop.getStop().getId().getId());
        }
        operation.setMatch(new TypedEntityMatch(Trip.class, new PropertyValueEntityMatch(new PropertyPathExpression("id"), new SimpleValueMatcher(trip.getId()))));
        this.strategy.addOperation(operation);
    }

    private Geometry buildPolygon(String polygonWKT) {
        try {
            return this.wktReader.read(polygonWKT);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Error parsing WKT string: %s".formatted(e.getMessage()), e);
        }
    }

    private boolean insidePolygon(Geometry geometry, double lon, double lat) {
        Point point = GEOMETRY_FACTORY.createPoint(new Coordinate(lon, lat));
        return geometry.contains((Geometry)point);
    }
}

