/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.onebusaway.collections.tuple.T2;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripsByBlockInSortedOrder {
    private static Logger _log = LoggerFactory.getLogger(TripsByBlockInSortedOrder.class);

    public static Map<String, List<Trip>> getTripsByBlockInSortedOrder(GtfsMutableRelationalDao dao) {
        HashMap<String, List<Trip>> tripsByBlockId = new HashMap<String, List<Trip>>();
        HashMap<Trip, Integer> averageStopTimeByTrip = new HashMap<Trip, Integer>();
        int totalTrips = 0;
        int tripsWithoutStopTimes = 0;
        for (Trip trip : dao.getAllTrips()) {
            ArrayList<Trip> trips;
            ++totalTrips;
            Object blockId = trip.getBlockId();
            if (blockId == null) {
                blockId = String.valueOf(trip.getId()) + "-" + ThreadLocalRandom.current().nextDouble();
            }
            if ((trips = (ArrayList<Trip>)tripsByBlockId.get(blockId)) == null) {
                trips = new ArrayList<Trip>();
                tripsByBlockId.put((String)blockId, trips);
            }
            trips.add(trip);
            List stopTimes = dao.getStopTimesForTrip(trip);
            if (stopTimes.isEmpty()) {
                ++tripsWithoutStopTimes;
                continue;
            }
            int arrivalTimes = 0;
            int arrivalTimeCount = 0;
            for (StopTime stopTime : stopTimes) {
                if (!stopTime.isArrivalTimeSet()) continue;
                arrivalTimes += stopTime.getArrivalTime();
                ++arrivalTimeCount;
            }
            if (arrivalTimeCount <= 0) continue;
            int averageArrivalTime = arrivalTimes / arrivalTimeCount;
            averageStopTimeByTrip.put(trip, averageArrivalTime);
        }
        _log.info("trips=" + totalTrips + " withoutStopTimes=" + tripsWithoutStopTimes);
        TripComparator c = new TripComparator(averageStopTimeByTrip);
        for (List tripsInBlock : tripsByBlockId.values()) {
            Collections.sort(tripsInBlock, c);
        }
        return tripsByBlockId;
    }

    public static Map<T2, List<Trip>> getTripsByBlockAndServiceIdInSortedOrder(GtfsMutableRelationalDao dao) {
        HashMap<T2, List<Trip>> tripsByBlockAndServiceId = new HashMap<T2, List<Trip>>();
        HashMap<Trip, Integer> averageStopTimeByTrip = new HashMap<Trip, Integer>();
        int totalTrips = 0;
        int tripsWithoutStopTimes = 0;
        for (Trip trip : dao.getAllTrips()) {
            T2Impl key;
            ArrayList<Trip> trips;
            ++totalTrips;
            Object blockId = trip.getBlockId();
            if (blockId == null) {
                blockId = String.valueOf(trip.getId()) + "-" + ThreadLocalRandom.current().nextDouble();
            }
            if ((trips = (ArrayList<Trip>)tripsByBlockAndServiceId.get(key = new T2Impl(trip.getServiceId(), (String)blockId))) == null) {
                trips = new ArrayList<Trip>();
                tripsByBlockAndServiceId.put(key, trips);
            }
            trips.add(trip);
            List stopTimes = dao.getStopTimesForTrip(trip);
            if (stopTimes.isEmpty()) {
                ++tripsWithoutStopTimes;
                continue;
            }
            int arrivalTimes = 0;
            int arrivalTimeCount = 0;
            for (StopTime stopTime : stopTimes) {
                if (!stopTime.isArrivalTimeSet()) continue;
                arrivalTimes += stopTime.getArrivalTime();
                ++arrivalTimeCount;
            }
            if (arrivalTimeCount <= 0) continue;
            int averageArrivalTime = arrivalTimes / arrivalTimeCount;
            averageStopTimeByTrip.put(trip, averageArrivalTime);
        }
        _log.info("trips=" + totalTrips + " withoutStopTimes=" + tripsWithoutStopTimes);
        TripComparator c = new TripComparator(averageStopTimeByTrip);
        for (List tripsInBlock : tripsByBlockAndServiceId.values()) {
            Collections.sort(tripsInBlock, c);
        }
        return tripsByBlockAndServiceId;
    }

    private static class TripComparator
    implements Comparator<Trip> {
        private Map<Trip, Integer> _averageArrivalTimesByTrip;

        public TripComparator(Map<Trip, Integer> averageStopTimeByTrip) {
            this._averageArrivalTimesByTrip = averageStopTimeByTrip;
        }

        @Override
        public int compare(Trip o1, Trip o2) {
            Integer st1 = this._averageArrivalTimesByTrip.get(o1);
            Integer st2 = this._averageArrivalTimesByTrip.get(o2);
            if (st1 == null && st2 == null) {
                return o1.getId().compareTo(o2.getId());
            }
            if (st1 == null) {
                return 1;
            }
            if (st2 == null) {
                return -1;
            }
            return st1.compareTo(st2);
        }
    }

    private static class T2Impl
    implements T2 {
        private String first = null;
        private String second;

        public T2Impl(AgencyAndId serviceId, String blockId) {
            if (serviceId != null) {
                this.first = serviceId.toString();
            }
            this.second = blockId;
        }

        public Object getFirst() {
            return this.first;
        }

        public Object getSecond() {
            return this.second;
        }

        public int hashCode() {
            return this.first.hashCode() + this.second.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            T2 t2 = (T2)o;
            return this.first.equals(t2.getFirst()) && this.second.equals(t2.getSecond());
        }
    }
}

