/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.collections.MappingLibrary;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class DeduplicateStopsStrategy
implements GtfsTransformStrategy {
    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        FactoryMap stopsById = new FactoryMap(new ArrayList());
        for (Stop stop : dao.getAllStops()) {
            AgencyAndId aid = stop.getId();
            String id = aid.getId();
            int index = id.indexOf(95);
            if (index == -1) continue;
            String stopCode = id.substring(0, index);
            AgencyAndId generalId = new AgencyAndId(aid.getAgencyId(), stopCode);
            ((List)stopsById.get(generalId)).add(stop);
        }
        Map stopTimesByStop = MappingLibrary.mapToValueList((Iterable)dao.getAllStopTimes(), (String)"stop", Stop.class);
        for (Map.Entry entry : stopsById.entrySet()) {
            AgencyAndId stopId = (AgencyAndId)entry.getKey();
            List stops = (List)entry.getValue();
            Stop stop = (Stop)stops.getFirst();
            dao.removeEntity((IdentityBean)stop);
            stop.setId(stopId);
            dao.saveEntity((Object)stop);
            for (int i = 1; i < stops.size(); ++i) {
                Stop duplicateStop = (Stop)stops.get(i);
                dao.removeEntity((IdentityBean)duplicateStop);
                List stopTimes = (List)stopTimesByStop.get(duplicateStop);
                if (stopTimes == null) continue;
                for (StopTime stopTime : stopTimes) {
                    stopTime.setStop((StopLocation)stop);
                }
            }
        }
    }
}

